/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.condition;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.xpack.support.clock.Clock;
import org.elasticsearch.xpack.watcher.condition.Condition;
import org.elasticsearch.xpack.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.watcher.support.Variables;
import org.elasticsearch.xpack.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.xpack.watcher.support.xcontent.ObjectPath;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

abstract class AbstractCompareCondition
extends Condition {
    static final Pattern DATE_MATH_PATTERN = Pattern.compile("<\\{(.+)\\}>");
    static final Pattern PATH_PATTERN = Pattern.compile("\\{\\{(.+)\\}\\}");
    private final Clock clock;

    protected AbstractCompareCondition(String type, Clock clock) {
        super(type);
        this.clock = clock;
    }

    @Override
    public final Condition.Result execute(WatchExecutionContext ctx) {
        HashMap<String, Object> resolvedValues = new HashMap<String, Object>();
        Map<String, Object> model = Variables.createCtxModel(ctx, ctx.payload());
        return this.doExecute(model, resolvedValues);
    }

    protected Object resolveConfiguredValue(Map<String, Object> resolvedValues, Map<String, Object> model, Object configuredValue) {
        if (configuredValue instanceof String) {
            Matcher matcher = DATE_MATH_PATTERN.matcher((String)configuredValue);
            if (matcher.matches()) {
                String dateMath = matcher.group(1);
                configuredValue = WatcherDateTimeUtils.parseDateMath(dateMath, DateTimeZone.UTC, this.clock);
                resolvedValues.put(dateMath, WatcherDateTimeUtils.formatDate((DateTime)configuredValue));
            } else {
                matcher = PATH_PATTERN.matcher((String)configuredValue);
                if (matcher.matches()) {
                    String configuredPath = matcher.group(1);
                    configuredValue = ObjectPath.eval(configuredPath, model);
                    resolvedValues.put(configuredPath, configuredValue);
                }
            }
        }
        return configuredValue;
    }

    protected abstract Condition.Result doExecute(Map<String, Object> var1, Map<String, Object> var2);
}

