/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ssl;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.X509ExtendedTrustManager;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.ssl.CertUtils;
import org.elasticsearch.xpack.ssl.TrustConfig;

class StoreTrustConfig
extends TrustConfig {
    final String trustStorePath;
    final String trustStorePassword;
    final String trustStoreAlgorithm;

    StoreTrustConfig(String trustStorePath, String trustStorePassword, String trustStoreAlgorithm) {
        this.trustStorePath = trustStorePath;
        this.trustStorePassword = trustStorePath != null ? Objects.requireNonNull(trustStorePassword, "truststore password must be specified") : trustStorePassword;
        this.trustStoreAlgorithm = trustStoreAlgorithm;
    }

    @Override
    X509ExtendedTrustManager createTrustManager(@Nullable Environment environment) {
        try {
            return CertUtils.trustManager(this.trustStorePath, this.trustStorePassword, this.trustStoreAlgorithm, environment);
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to initialize a TrustManagerFactory", (Throwable)e, new Object[0]);
        }
    }

    @Override
    List<Path> filesToMonitor(@Nullable Environment environment) {
        if (this.trustStorePath == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(CertUtils.resolvePath(this.trustStorePath, environment));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreTrustConfig that = (StoreTrustConfig)o;
        if (this.trustStorePath != null ? !this.trustStorePath.equals(that.trustStorePath) : that.trustStorePath != null) {
            return false;
        }
        if (this.trustStorePassword != null ? !this.trustStorePassword.equals(that.trustStorePassword) : that.trustStorePassword != null) {
            return false;
        }
        return this.trustStoreAlgorithm != null ? this.trustStoreAlgorithm.equals(that.trustStoreAlgorithm) : that.trustStoreAlgorithm == null;
    }

    @Override
    public int hashCode() {
        int result = this.trustStorePath != null ? this.trustStorePath.hashCode() : 0;
        result = 31 * result + (this.trustStorePassword != null ? this.trustStorePassword.hashCode() : 0);
        result = 31 * result + (this.trustStoreAlgorithm != null ? this.trustStoreAlgorithm.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "trustStorePath=[" + this.trustStorePath + "], trustStoreAlgorithm=[" + this.trustStoreAlgorithm + "]";
    }
}

