/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.permission;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.elasticsearch.cluster.metadata.AliasOrIndex;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.xpack.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.security.authz.permission.FieldPermissions;
import org.elasticsearch.xpack.security.authz.permission.FieldPermissionsCache;
import org.elasticsearch.xpack.security.authz.privilege.IndexPrivilege;
import org.elasticsearch.xpack.security.support.Automatons;

public final class IndicesPermission
implements Iterable<Group> {
    public static final IndicesPermission NONE = new IndicesPermission(new Group[0]);
    private final Function<String, Predicate<String>> loadingFunction;
    private final ConcurrentHashMap<String, Predicate<String>> allowedIndicesMatchersForAction = new ConcurrentHashMap();
    private final Group[] groups;

    public IndicesPermission(Group ... groups) {
        this.groups = groups;
        this.loadingFunction = action -> {
            ArrayList<String> indices = new ArrayList<String>();
            for (Group group : groups) {
                if (!group.actionMatcher.test(action)) continue;
                indices.addAll(Arrays.asList(group.indices));
            }
            return Automatons.predicate(indices);
        };
    }

    @Override
    public Iterator<Group> iterator() {
        return Arrays.asList(this.groups).iterator();
    }

    public Group[] groups() {
        return this.groups;
    }

    public Predicate<String> allowedIndicesMatcher(String action) {
        return this.allowedIndicesMatchersForAction.computeIfAbsent(action, this.loadingFunction);
    }

    public boolean check(String action) {
        for (Group group : this.groups) {
            if (!group.check(action)) continue;
            return true;
        }
        return false;
    }

    public Map<String, IndicesAccessControl.IndexAccessControl> authorize(String action, Set<String> requestedIndicesOrAliases, MetaData metaData, FieldPermissionsCache fieldPermissionsCache) {
        SortedMap allAliasesAndIndices = metaData.getAliasAndIndexLookup();
        HashMap<String, Set> fieldPermissionsByIndex = new HashMap<String, Set>();
        HashMap<String, DocumentLevelPermissions> roleQueriesByIndex = new HashMap<String, DocumentLevelPermissions>();
        HashMap<String, Boolean> grantedBuilder = new HashMap<String, Boolean>();
        for (String indexOrAlias : requestedIndicesOrAliases) {
            boolean granted = false;
            HashSet<String> concreteIndices = new HashSet<String>();
            AliasOrIndex aliasOrIndex = (AliasOrIndex)allAliasesAndIndices.get(indexOrAlias);
            if (aliasOrIndex != null) {
                for (IndexMetaData indexMetaData : aliasOrIndex.getIndices()) {
                    concreteIndices.add(indexMetaData.getIndex().getName());
                }
            }
            for (Group group : this.groups) {
                if (!group.check(action, indexOrAlias)) continue;
                granted = true;
                for (String index : concreteIndices) {
                    Set fieldPermissions = fieldPermissionsByIndex.computeIfAbsent(index, k -> new HashSet());
                    fieldPermissionsByIndex.put(indexOrAlias, fieldPermissions);
                    fieldPermissions.add(group.getFieldPermissions());
                    DocumentLevelPermissions permissions = roleQueriesByIndex.computeIfAbsent(index, k -> new DocumentLevelPermissions());
                    roleQueriesByIndex.putIfAbsent(indexOrAlias, permissions);
                    if (group.hasQuery()) {
                        permissions.addAll(group.getQuery());
                        continue;
                    }
                    permissions.setAllowAll(true);
                }
            }
            if (concreteIndices.isEmpty()) {
                grantedBuilder.put(indexOrAlias, granted);
                continue;
            }
            grantedBuilder.put(indexOrAlias, granted);
            for (String concreteIndex : concreteIndices) {
                grantedBuilder.put(concreteIndex, granted);
            }
        }
        HashMap<String, IndicesAccessControl.IndexAccessControl> indexPermissions = new HashMap<String, IndicesAccessControl.IndexAccessControl>();
        for (Map.Entry entry : grantedBuilder.entrySet()) {
            String index = (String)entry.getKey();
            DocumentLevelPermissions permissions = (DocumentLevelPermissions)roleQueriesByIndex.get(index);
            Set<BytesReference> roleQueries = permissions != null && !permissions.isAllowAll() ? Collections.unmodifiableSet(permissions.queries) : null;
            Set indexFieldPermissions = (Set)fieldPermissionsByIndex.get(index);
            FieldPermissions fieldPermissions = indexFieldPermissions != null && !indexFieldPermissions.isEmpty() ? (indexFieldPermissions.size() == 1 ? (FieldPermissions)indexFieldPermissions.iterator().next() : fieldPermissionsCache.getFieldPermissions(indexFieldPermissions)) : FieldPermissions.DEFAULT;
            indexPermissions.put(index, new IndicesAccessControl.IndexAccessControl((Boolean)entry.getValue(), fieldPermissions, roleQueries));
        }
        return Collections.unmodifiableMap(indexPermissions);
    }

    private static class DocumentLevelPermissions {
        private Set<BytesReference> queries = null;
        private boolean allowAll = false;

        private DocumentLevelPermissions() {
        }

        private void addAll(Set<BytesReference> query) {
            if (!this.allowAll) {
                if (this.queries == null) {
                    this.queries = new HashSet<BytesReference>();
                }
                this.queries.addAll(query);
            }
        }

        private boolean isAllowAll() {
            return this.allowAll;
        }

        private void setAllowAll(boolean allowAll) {
            this.allowAll = allowAll;
        }
    }

    public static class Group {
        private final IndexPrivilege privilege;
        private final Predicate<String> actionMatcher;
        private final String[] indices;
        private final Predicate<String> indexNameMatcher;
        private final FieldPermissions fieldPermissions;
        private final Set<BytesReference> query;

        public FieldPermissions getFieldPermissions() {
            return this.fieldPermissions;
        }

        public Group(IndexPrivilege privilege, FieldPermissions fieldPermissions, @Nullable Set<BytesReference> query, String ... indices) {
            assert (indices.length != 0);
            this.privilege = privilege;
            this.actionMatcher = privilege.predicate();
            this.indices = indices;
            this.indexNameMatcher = Automatons.predicate(indices);
            this.fieldPermissions = Objects.requireNonNull(fieldPermissions);
            this.query = query;
        }

        public IndexPrivilege privilege() {
            return this.privilege;
        }

        public String[] indices() {
            return this.indices;
        }

        @Nullable
        public Set<BytesReference> getQuery() {
            return this.query;
        }

        private boolean check(String action) {
            return this.actionMatcher.test(action);
        }

        private boolean check(String action, String index) {
            assert (index != null);
            return this.check(action) && this.indexNameMatcher.test(index);
        }

        boolean hasQuery() {
            return this.query != null;
        }
    }
}

