/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.permission;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;

public final class FieldPermissionsDefinition {
    private final Set<FieldGrantExcludeGroup> fieldGrantExcludeGroups;

    public FieldPermissionsDefinition(String[] grant, String[] exclude) {
        this(Collections.singleton(new FieldGrantExcludeGroup(grant, exclude)));
    }

    public FieldPermissionsDefinition(Set<FieldGrantExcludeGroup> fieldGrantExcludeGroups) {
        this.fieldGrantExcludeGroups = Collections.unmodifiableSet(fieldGrantExcludeGroups);
    }

    public Set<FieldGrantExcludeGroup> getFieldGrantExcludeGroups() {
        return this.fieldGrantExcludeGroups;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldPermissionsDefinition that = (FieldPermissionsDefinition)o;
        return this.fieldGrantExcludeGroups != null ? this.fieldGrantExcludeGroups.equals(that.fieldGrantExcludeGroups) : that.fieldGrantExcludeGroups == null;
    }

    public int hashCode() {
        return this.fieldGrantExcludeGroups != null ? this.fieldGrantExcludeGroups.hashCode() : 0;
    }

    public static final class FieldGrantExcludeGroup {
        private final String[] grantedFields;
        private final String[] excludedFields;

        public FieldGrantExcludeGroup(String[] grantedFields, String[] excludedFields) {
            this.grantedFields = grantedFields;
            this.excludedFields = excludedFields;
        }

        public String[] getGrantedFields() {
            return this.grantedFields;
        }

        public String[] getExcludedFields() {
            return this.excludedFields;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldGrantExcludeGroup that = (FieldGrantExcludeGroup)o;
            if (!Arrays.equals(this.grantedFields, that.grantedFields)) {
                return false;
            }
            return Arrays.equals(this.excludedFields, that.excludedFields);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.grantedFields);
            result = 31 * result + Arrays.hashCode(this.excludedFields);
            return result;
        }
    }
}

