/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.support.CachingUsernamePasswordRealm;
import org.elasticsearch.xpack.security.authc.support.DnRoleMapper;
import org.elasticsearch.xpack.security.authc.support.UserRoleMapper;
import org.elasticsearch.xpack.security.authc.support.mapper.NativeRoleMappingStore;

public class CompositeRoleMapper
implements UserRoleMapper {
    private List<UserRoleMapper> delegates;

    public CompositeRoleMapper(String realmType, RealmConfig realmConfig, ResourceWatcherService watcherService, NativeRoleMappingStore nativeRoleMappingStore) {
        this(new DnRoleMapper(realmType, realmConfig, watcherService), nativeRoleMappingStore);
    }

    private CompositeRoleMapper(UserRoleMapper ... delegates) {
        this.delegates = new ArrayList<UserRoleMapper>(Arrays.asList(delegates));
    }

    @Override
    public void resolveRoles(UserRoleMapper.UserData user, ActionListener<Set<String>> listener) {
        GroupedActionListener groupListener = new GroupedActionListener(ActionListener.wrap(composite -> listener.onResponse(composite.stream().flatMap(Collection::stream).collect(Collectors.toSet())), arg_0 -> listener.onFailure(arg_0)), this.delegates.size(), Collections.emptyList());
        this.delegates.forEach(mapper -> mapper.resolveRoles(user, (ActionListener<Set<String>>)groupListener));
    }

    @Override
    public void refreshRealmOnChange(CachingUsernamePasswordRealm realm) {
        this.delegates.forEach(mapper -> mapper.refreshRealmOnChange(realm));
    }

    public static Collection<? extends Setting<?>> getSettings() {
        return DnRoleMapper.getSettings();
    }
}

