/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.SearchResultEntry;
import java.io.Closeable;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.ldap.ActiveDirectoryGroupsResolver;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapMetaDataResolver;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSearchScope;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapUtils;
import org.elasticsearch.xpack.security.authc.ldap.support.SessionFactory;
import org.elasticsearch.xpack.ssl.SSLService;

class ActiveDirectorySessionFactory
extends SessionFactory {
    static final String AD_DOMAIN_NAME_SETTING = "domain_name";
    static final String AD_GROUP_SEARCH_BASEDN_SETTING = "group_search.base_dn";
    static final String AD_GROUP_SEARCH_SCOPE_SETTING = "group_search.scope";
    static final String AD_USER_SEARCH_BASEDN_SETTING = "user_search.base_dn";
    static final String AD_USER_SEARCH_FILTER_SETTING = "user_search.filter";
    static final String AD_UPN_USER_SEARCH_FILTER_SETTING = "user_search.upn_filter";
    static final String AD_DOWN_LEVEL_USER_SEARCH_FILTER_SETTING = "user_search.down_level_filter";
    static final String AD_USER_SEARCH_SCOPE_SETTING = "user_search.scope";
    private static final String NETBIOS_NAME_FILTER_TEMPLATE = "(netbiosname={0})";
    final DefaultADAuthenticator defaultADAuthenticator;
    final DownLevelADAuthenticator downLevelADAuthenticator;
    final UpnADAuthenticator upnADAuthenticator;

    ActiveDirectorySessionFactory(RealmConfig config, SSLService sslService) {
        super(config, sslService);
        Settings settings = config.settings();
        String domainName = settings.get(AD_DOMAIN_NAME_SETTING);
        if (domainName == null) {
            throw new IllegalArgumentException("missing [domain_name] setting for active directory");
        }
        String domainDN = ActiveDirectorySessionFactory.buildDnFromDomain(domainName);
        ActiveDirectoryGroupsResolver groupResolver = new ActiveDirectoryGroupsResolver(settings.getAsSettings("group_search"), domainDN, this.ignoreReferralErrors);
        LdapMetaDataResolver metaDataResolver = new LdapMetaDataResolver(config.settings(), this.ignoreReferralErrors);
        this.defaultADAuthenticator = new DefaultADAuthenticator(config, this.timeout, this.ignoreReferralErrors, this.logger, groupResolver, metaDataResolver, domainDN);
        this.downLevelADAuthenticator = new DownLevelADAuthenticator(config, this.timeout, this.ignoreReferralErrors, this.logger, groupResolver, metaDataResolver, domainDN, sslService);
        this.upnADAuthenticator = new UpnADAuthenticator(config, this.timeout, this.ignoreReferralErrors, this.logger, groupResolver, metaDataResolver, domainDN);
    }

    @Override
    protected String[] getDefaultLdapUrls(Settings settings) {
        return new String[]{"ldap://" + settings.get(AD_DOMAIN_NAME_SETTING) + ":389"};
    }

    @Override
    public void session(String username, SecureString password, ActionListener<LdapSession> listener) {
        Runnable runnable;
        try {
            LDAPConnection connection = this.serverSet.getConnection();
            runnable = () -> this.getADAuthenticator(username).authenticate(connection, username, password, (ActionListener<LdapSession>)ActionListener.wrap(arg_0 -> ((ActionListener)listener).onResponse(arg_0), e -> {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                listener.onFailure(e);
            }));
        }
        catch (LDAPException e) {
            runnable = () -> listener.onFailure((Exception)((Object)e));
        }
        runnable.run();
    }

    static String buildDnFromDomain(String domain) {
        return "DC=" + domain.replace(".", ",DC=");
    }

    public static Set<Setting<?>> getSettings() {
        HashSet settings = new HashSet();
        settings.addAll(SessionFactory.getSettings());
        settings.add(Setting.simpleString((String)AD_DOMAIN_NAME_SETTING, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)AD_GROUP_SEARCH_BASEDN_SETTING, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)AD_GROUP_SEARCH_SCOPE_SETTING, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)AD_USER_SEARCH_BASEDN_SETTING, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)AD_USER_SEARCH_FILTER_SETTING, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)AD_UPN_USER_SEARCH_FILTER_SETTING, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)AD_DOWN_LEVEL_USER_SEARCH_FILTER_SETTING, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)AD_USER_SEARCH_SCOPE_SETTING, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        return settings;
    }

    ADAuthenticator getADAuthenticator(String username) {
        if (username.indexOf(92) > 0) {
            return this.downLevelADAuthenticator;
        }
        if (username.indexOf("@") > 0) {
            return this.upnADAuthenticator;
        }
        return this.defaultADAuthenticator;
    }

    static class UpnADAuthenticator
    extends ADAuthenticator {
        static final String UPN_USER_FILTER = "(&(objectClass=user)(|(sAMAccountName={0})(userPrincipalName={1})))";

        UpnADAuthenticator(RealmConfig config, TimeValue timeout, boolean ignoreReferralErrors, Logger logger, LdapSession.GroupsResolver groupsResolver, LdapMetaDataResolver metaDataResolver, String domainDN) {
            super(config, timeout, ignoreReferralErrors, logger, groupsResolver, metaDataResolver, domainDN, ActiveDirectorySessionFactory.AD_UPN_USER_SEARCH_FILTER_SETTING, UPN_USER_FILTER);
        }

        @Override
        void searchForDN(LDAPConnection connection, String username, SecureString password, int timeLimitSeconds, ActionListener<SearchResultEntry> listener) {
            String[] parts = username.split("@");
            assert (parts.length == 2);
            String accountName = parts[0];
            String domainName = parts[1];
            String domainDN = ActiveDirectorySessionFactory.buildDnFromDomain(domainName);
            try {
                Filter filter = LdapUtils.createFilter(UPN_USER_FILTER, accountName, username);
                LdapUtils.searchForEntry(connection, domainDN, LdapSearchScope.SUB_TREE.scope(), filter, timeLimitSeconds, this.ignoreReferralErrors, listener, LdapUtils.attributesToSearchFor(this.groupsResolver.attributes()));
            }
            catch (LDAPException e) {
                listener.onFailure((Exception)((Object)e));
            }
        }
    }

    static class DownLevelADAuthenticator
    extends ADAuthenticator {
        static final String DOWN_LEVEL_FILTER = "(&(objectClass=user)(sAMAccountName={0}))";
        Cache<String, String> domainNameCache = CacheBuilder.builder().setMaximumWeight(100L).build();
        final String domainDN;
        final Settings settings;
        final SSLService sslService;
        final RealmConfig config;

        DownLevelADAuthenticator(RealmConfig config, TimeValue timeout, boolean ignoreReferralErrors, Logger logger, LdapSession.GroupsResolver groupsResolver, LdapMetaDataResolver metaDataResolver, String domainDN, SSLService sslService) {
            super(config, timeout, ignoreReferralErrors, logger, groupsResolver, metaDataResolver, domainDN, ActiveDirectorySessionFactory.AD_DOWN_LEVEL_USER_SEARCH_FILTER_SETTING, DOWN_LEVEL_FILTER);
            this.domainDN = domainDN;
            this.settings = config.settings();
            this.sslService = sslService;
            this.config = config;
        }

        @Override
        void searchForDN(LDAPConnection connection, String username, SecureString password, int timeLimitSeconds, ActionListener<SearchResultEntry> listener) {
            String[] parts = username.split("\\\\");
            assert (parts.length == 2);
            String netBiosDomainName = parts[0];
            String accountName = parts[1];
            this.netBiosDomainNameToDn(connection, netBiosDomainName, username, password, timeLimitSeconds, (ActionListener<String>)ActionListener.wrap(domainDN -> {
                if (domainDN == null) {
                    IOUtils.close((Closeable[])new Closeable[]{connection});
                    listener.onResponse(null);
                } else {
                    try {
                        LdapUtils.searchForEntry(connection, domainDN, LdapSearchScope.SUB_TREE.scope(), LdapUtils.createFilter(this.userSearchFilter, accountName), timeLimitSeconds, this.ignoreReferralErrors, listener, LdapUtils.attributesToSearchFor(this.groupsResolver.attributes()));
                    }
                    catch (LDAPException e) {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                        listener.onFailure((Exception)((Object)e));
                    }
                }
            }, e -> {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                listener.onFailure(e);
            }));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void netBiosDomainNameToDn(LDAPConnection connection, String netBiosDomainName, String username, SecureString password, int timeLimitSeconds, ActionListener<String> listener) {
            String cachedName = (String)this.domainNameCache.get((Object)netBiosDomainName);
            if (cachedName != null) {
                listener.onResponse((Object)cachedName);
                return;
            }
            if (DownLevelADAuthenticator.usingGlobalCatalog(this.settings, connection)) {
                LDAPConnectionOptions options = ActiveDirectorySessionFactory.connectionOptions(this.config, this.sslService, this.logger);
                boolean startedSearching = false;
                LDAPConnection searchConnection = null;
                try {
                    Filter filter = LdapUtils.createFilter(ActiveDirectorySessionFactory.NETBIOS_NAME_FILTER_TEMPLATE, netBiosDomainName);
                    searchConnection = connection.getSSLSession() != null ? new LDAPConnection(connection.getSocketFactory(), options, connection.getConnectedAddress(), 636) : new LDAPConnection(options, connection.getConnectedAddress(), 389);
                    searchConnection.bind(username, new String(password.getChars()));
                    LDAPConnection finalConnection = searchConnection;
                    LdapUtils.search(finalConnection, this.domainDN, LdapSearchScope.SUB_TREE.scope(), filter, timeLimitSeconds, this.ignoreReferralErrors, (ActionListener<List<SearchResultEntry>>)ActionListener.wrap(results -> {
                        IOUtils.close((Closeable[])new Closeable[]{finalConnection});
                        DownLevelADAuthenticator.handleSearchResults(results, netBiosDomainName, this.domainNameCache, listener);
                    }, e -> {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                        listener.onFailure(e);
                    }), "ncname");
                    return;
                }
                catch (LDAPException e2) {
                    try {
                        listener.onFailure((Exception)((Object)e2));
                        if (startedSearching) return;
                    }
                    catch (Throwable throwable) {
                        if (startedSearching) throw throwable;
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{searchConnection});
                        throw throwable;
                    }
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{searchConnection});
                    return;
                }
            }
            try {
                Filter filter = LdapUtils.createFilter(ActiveDirectorySessionFactory.NETBIOS_NAME_FILTER_TEMPLATE, netBiosDomainName);
                LdapUtils.search(connection, this.domainDN, LdapSearchScope.SUB_TREE.scope(), filter, timeLimitSeconds, this.ignoreReferralErrors, (ActionListener<List<SearchResultEntry>>)ActionListener.wrap(results -> DownLevelADAuthenticator.handleSearchResults(results, netBiosDomainName, this.domainNameCache, listener), e -> {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                    listener.onFailure(e);
                }), "ncname");
                return;
            }
            catch (LDAPException e3) {
                listener.onFailure((Exception)((Object)e3));
            }
        }

        static void handleSearchResults(List<SearchResultEntry> results, String netBiosDomainName, Cache<String, String> domainNameCache, ActionListener<String> listener) {
            Optional<SearchResultEntry> entry = results.stream().filter(r -> r.hasAttribute("ncname")).findFirst();
            if (entry.isPresent()) {
                String value = entry.get().getAttributeValue("ncname");
                try {
                    domainNameCache.computeIfAbsent((Object)netBiosDomainName, s -> value);
                }
                catch (ExecutionException e) {
                    throw new AssertionError("failed to load constant non-null value", e);
                }
                listener.onResponse((Object)value);
            } else {
                listener.onResponse(null);
            }
        }

        static boolean usingGlobalCatalog(Settings settings, LDAPConnection ldapConnection) {
            Boolean usingGlobalCatalog = settings.getAsBoolean("global_catalog", null);
            if (usingGlobalCatalog != null) {
                return usingGlobalCatalog;
            }
            return ldapConnection.getConnectedPort() == 3268 || ldapConnection.getConnectedPort() == 3269;
        }
    }

    static class DefaultADAuthenticator
    extends ADAuthenticator {
        final String domainName;

        DefaultADAuthenticator(RealmConfig realm, TimeValue timeout, boolean ignoreReferralErrors, Logger logger, LdapSession.GroupsResolver groupsResolver, LdapMetaDataResolver metaDataResolver, String domainDN) {
            super(realm, timeout, ignoreReferralErrors, logger, groupsResolver, metaDataResolver, domainDN, ActiveDirectorySessionFactory.AD_USER_SEARCH_FILTER_SETTING, "(&(objectClass=user)(|(sAMAccountName={0})(userPrincipalName={0}@" + DefaultADAuthenticator.domainName(realm) + ")))");
            this.domainName = DefaultADAuthenticator.domainName(realm);
        }

        private static String domainName(RealmConfig realm) {
            return realm.settings().get(ActiveDirectorySessionFactory.AD_DOMAIN_NAME_SETTING);
        }

        @Override
        void searchForDN(LDAPConnection connection, String username, SecureString password, int timeLimitSeconds, ActionListener<SearchResultEntry> listener) {
            try {
                LdapUtils.searchForEntry(connection, this.userSearchDN, this.userSearchScope.scope(), LdapUtils.createFilter(this.userSearchFilter, username), timeLimitSeconds, this.ignoreReferralErrors, listener, LdapUtils.attributesToSearchFor(this.groupsResolver.attributes()));
            }
            catch (LDAPException e) {
                listener.onFailure((Exception)((Object)e));
            }
        }

        @Override
        String bindUsername(String username) {
            return username + "@" + this.domainName;
        }
    }

    static abstract class ADAuthenticator {
        private final RealmConfig realm;
        final TimeValue timeout;
        final boolean ignoreReferralErrors;
        final Logger logger;
        final LdapSession.GroupsResolver groupsResolver;
        final LdapMetaDataResolver metaDataResolver;
        final String userSearchDN;
        final LdapSearchScope userSearchScope;
        final String userSearchFilter;

        ADAuthenticator(RealmConfig realm, TimeValue timeout, boolean ignoreReferralErrors, Logger logger, LdapSession.GroupsResolver groupsResolver, LdapMetaDataResolver metaDataResolver, String domainDN, String userSearchFilterSetting, String defaultUserSearchFilter) {
            this.realm = realm;
            this.timeout = timeout;
            this.ignoreReferralErrors = ignoreReferralErrors;
            this.logger = logger;
            this.groupsResolver = groupsResolver;
            this.metaDataResolver = metaDataResolver;
            Settings settings = realm.settings();
            this.userSearchDN = settings.get(ActiveDirectorySessionFactory.AD_USER_SEARCH_BASEDN_SETTING, domainDN);
            this.userSearchScope = LdapSearchScope.resolve(settings.get(ActiveDirectorySessionFactory.AD_USER_SEARCH_SCOPE_SETTING), LdapSearchScope.SUB_TREE);
            this.userSearchFilter = settings.get(userSearchFilterSetting, defaultUserSearchFilter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final void authenticate(LDAPConnection connection, String username, SecureString password, ActionListener<LdapSession> listener) {
            boolean success = false;
            try {
                connection.bind(this.bindUsername(username), new String(password.getChars()));
                this.searchForDN(connection, username, password, Math.toIntExact(this.timeout.seconds()), (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
                    if (entry == null) {
                        IOUtils.close((Closeable[])new Closeable[]{connection});
                        listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("search for user [" + username + "] by principle name yielded no results", new Object[0])));
                    } else {
                        String dn = entry.getDN();
                        listener.onResponse((Object)new LdapSession(this.logger, this.realm, (LDAPInterface)connection, dn, this.groupsResolver, this.metaDataResolver, this.timeout, null));
                    }
                }, e -> {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                    listener.onFailure(e);
                }));
                return;
            }
            catch (LDAPException e2) {
                try {
                    listener.onFailure((Exception)((Object)e2));
                    if (success) return;
                }
                catch (Throwable throwable) {
                    if (success) throw throwable;
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                return;
            }
        }

        String bindUsername(String username) {
            return username;
        }

        final String getUserSearchFilter() {
            return this.userSearchFilter;
        }

        abstract void searchForDN(LDAPConnection var1, String var2, SecureString var3, int var4, ActionListener<SearchResultEntry> var5);
    }
}

