/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.realm;

import java.io.IOException;
import org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ClearRealmCacheRequest
extends BaseNodesRequest<ClearRealmCacheRequest> {
    String[] realms;
    String[] usernames;

    public boolean allRealms() {
        return this.realms == null || this.realms.length == 0;
    }

    public String[] realms() {
        return this.realms;
    }

    public ClearRealmCacheRequest realms(String ... realms) {
        this.realms = realms;
        return this;
    }

    public boolean allUsernames() {
        return this.usernames == null || this.usernames.length == 0;
    }

    public String[] usernames() {
        return this.usernames;
    }

    public ClearRealmCacheRequest usernames(String ... usernames) {
        this.usernames = usernames;
        return this;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.realms = in.readStringArray();
        this.usernames = in.readStringArray();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.realms);
        out.writeStringArrayNullable(this.usernames);
    }

    public static class Node
    extends BaseNodeRequest {
        String[] realms;
        String[] usernames;

        public Node() {
        }

        Node(ClearRealmCacheRequest request, String nodeId) {
            super(nodeId);
            this.realms = request.realms;
            this.usernames = request.usernames;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.realms = in.readStringArray();
            this.usernames = in.readStringArray();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArrayNullable(this.realms);
            out.writeStringArrayNullable(this.usernames);
        }
    }
}

