/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.filter;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.security.SecurityContext;
import org.elasticsearch.xpack.security.action.SecurityActionMapper;
import org.elasticsearch.xpack.security.action.interceptor.RequestInterceptor;
import org.elasticsearch.xpack.security.audit.AuditTrail;
import org.elasticsearch.xpack.security.audit.AuditTrailService;
import org.elasticsearch.xpack.security.authc.Authentication;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authz.AuthorizationService;
import org.elasticsearch.xpack.security.authz.AuthorizationUtils;
import org.elasticsearch.xpack.security.authz.permission.Role;
import org.elasticsearch.xpack.security.authz.privilege.HealthAndStatsPrivilege;
import org.elasticsearch.xpack.security.crypto.CryptoService;
import org.elasticsearch.xpack.security.support.Automatons;
import org.elasticsearch.xpack.security.support.Exceptions;
import org.elasticsearch.xpack.security.user.SystemUser;
import org.elasticsearch.xpack.security.user.User;

public class SecurityActionFilter
extends AbstractComponent
implements ActionFilter {
    private static final Predicate<String> LICENSE_EXPIRATION_ACTION_MATCHER = HealthAndStatsPrivilege.INSTANCE.predicate();
    private static final Predicate<String> SECURITY_ACTION_MATCHER = Automatons.predicate("cluster:admin/xpack/security*");
    private final AuthenticationService authcService;
    private final AuthorizationService authzService;
    private final CryptoService cryptoService;
    private final AuditTrail auditTrail;
    private final SecurityActionMapper actionMapper = new SecurityActionMapper();
    private final Set<RequestInterceptor> requestInterceptors;
    private final XPackLicenseState licenseState;
    private final ThreadContext threadContext;
    private final SecurityContext securityContext;
    private final DestructiveOperations destructiveOperations;
    private final ClusterService clusterService;

    @Inject
    public SecurityActionFilter(Settings settings, AuthenticationService authcService, AuthorizationService authzService, CryptoService cryptoService, AuditTrailService auditTrail, XPackLicenseState licenseState, Set<RequestInterceptor> requestInterceptors, ThreadPool threadPool, SecurityContext securityContext, DestructiveOperations destructiveOperations, ClusterService clusterService) {
        super(settings);
        this.authcService = authcService;
        this.authzService = authzService;
        this.cryptoService = cryptoService;
        this.auditTrail = auditTrail;
        this.licenseState = licenseState;
        this.requestInterceptors = requestInterceptors;
        this.threadContext = threadPool.getThreadContext();
        this.securityContext = securityContext;
        this.destructiveOperations = destructiveOperations;
        this.clusterService = clusterService;
    }

    public void apply(Task task, String action, ActionRequest request, ActionListener listener, ActionFilterChain chain) {
        block20: {
            if (!this.licenseState.isStatsAndHealthAllowed() && LICENSE_EXPIRATION_ACTION_MATCHER.test(action)) {
                this.logger.error("blocking [{}] operation due to expired license. Cluster health, cluster stats and indices stats \noperations are blocked on license expiration. All data operations (read and write) continue to work. \nIf you have a new license, please update it. Otherwise, please reach out to your support contact.", (Object)action);
                throw LicenseUtils.newComplianceException("security");
            }
            if (this.licenseState.isAuthAllowed()) {
                boolean useSystemUser = AuthorizationUtils.shouldReplaceUserWithSystem(this.threadContext, action);
                Supplier toRestore = this.threadContext.newRestorableContext(true);
                ContextPreservingActionListener signingListener = new ContextPreservingActionListener(toRestore, ActionListener.wrap(r -> {
                    try {
                        listener.onResponse((Object)this.sign(r));
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
                ActionListener authenticatedListener = ActionListener.wrap(arg_0 -> SecurityActionFilter.lambda$apply$1(chain, task, action, request, (ActionListener)signingListener, arg_0), arg_0 -> ((ActionListener)signingListener).onFailure(arg_0));
                try {
                    if (useSystemUser) {
                        this.securityContext.executeAsUser(SystemUser.INSTANCE, original -> {
                            try {
                                this.applyInternal(action, request, (ActionListener<Void>)authenticatedListener);
                            }
                            catch (IOException e) {
                                listener.onFailure((Exception)e);
                            }
                        }, Version.CURRENT);
                        break block20;
                    }
                    try (ThreadContext.StoredContext ignore = this.threadContext.newStoredContext(true);){
                        this.applyInternal(action, request, (ActionListener<Void>)authenticatedListener);
                    }
                }
                catch (Exception e) {
                    listener.onFailure(e);
                }
            } else if (SECURITY_ACTION_MATCHER.test(action)) {
                listener.onFailure((Exception)((Object)LicenseUtils.newComplianceException("security")));
            } else {
                chain.proceed(task, action, request, listener);
            }
        }
    }

    public int order() {
        return Integer.MIN_VALUE;
    }

    private void applyInternal(String action, ActionRequest request, ActionListener<Void> listener) throws IOException {
        if ("indices:admin/close".equals(action) || "indices:admin/open".equals(action) || "indices:admin/delete".equals(action)) {
            IndicesRequest indicesRequest = (IndicesRequest)request;
            try {
                this.destructiveOperations.failDestructive(indicesRequest.indices());
            }
            catch (IllegalArgumentException e) {
                listener.onFailure((Exception)e);
                return;
            }
        }
        String securityAction = this.actionMapper.action(action, (TransportRequest)request);
        this.authcService.authenticate(securityAction, (TransportMessage)request, SystemUser.INSTANCE, Version.CURRENT, (ActionListener<Authentication>)ActionListener.wrap(authc -> this.authorizeRequest((Authentication)authc, securityAction, request, (ActionListener)listener), arg_0 -> listener.onFailure(arg_0)));
    }

    void authorizeRequest(Authentication authentication, String securityAction, ActionRequest request, ActionListener listener) {
        if (authentication == null) {
            listener.onFailure((Exception)new IllegalArgumentException("authentication must be non null for authorization"));
        } else {
            AuthorizationUtils.AsyncAuthorizer asyncAuthorizer = new AuthorizationUtils.AsyncAuthorizer(authentication, listener, (userRoles, runAsRoles) -> {
                this.authzService.authorize(authentication, securityAction, (TransportRequest)request, (Role)userRoles, (Role)runAsRoles);
                User user = authentication.getUser();
                ActionRequest unsignedRequest = this.unsign(user, securityAction, request);
                for (RequestInterceptor interceptor : this.requestInterceptors) {
                    if (!interceptor.supports((TransportRequest)unsignedRequest)) continue;
                    interceptor.intercept(unsignedRequest, user);
                }
                listener.onResponse(null);
            });
            asyncAuthorizer.authorize(this.authzService);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ActionRequest unsign(User user, String action, ActionRequest request) {
        try {
            boolean signingRequired;
            ClusterState state = this.clusterService.state();
            boolean bl = signingRequired = state.nodes().getMinNodeVersion().before(Version.V_5_5_0_UNRELEASED) && this.cryptoService.isSystemKeyPresent();
            if (request instanceof SearchScrollRequest) {
                SearchScrollRequest scrollRequest = (SearchScrollRequest)request;
                String scrollId = scrollRequest.scrollId();
                if (!signingRequired) {
                    if (!this.cryptoService.isSigned(scrollId)) return request;
                    scrollRequest.scrollId(this.cryptoService.unsignAndVerify(scrollId, null));
                    return request;
                }
                if (this.cryptoService.isSigned(scrollId)) {
                    scrollRequest.scrollId(this.cryptoService.unsignAndVerify(scrollId, null));
                    return request;
                }
                this.logger.error("scroll id [{}] is not signed but is expected to be. nodes [{}], minimum node version [{}]", (Object)scrollId, (Object)state.nodes(), (Object)state.nodes().getMinNodeVersion());
                this.auditTrail.tamperedRequest(user, action, (TransportMessage)request);
                throw Exceptions.authorizationError("invalid request", new Object[0]);
            }
            if (!(request instanceof ClearScrollRequest)) return request;
            ClearScrollRequest clearScrollRequest = (ClearScrollRequest)request;
            boolean isClearAllScrollRequest = clearScrollRequest.scrollIds().contains("_all");
            if (isClearAllScrollRequest) return request;
            List signedIds = clearScrollRequest.scrollIds();
            ArrayList<String> unsignedIds = new ArrayList<String>(signedIds.size());
            Iterator iterator = signedIds.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    clearScrollRequest.scrollIds(unsignedIds);
                    return request;
                }
                String signedId = (String)iterator.next();
                if (signingRequired) {
                    if (!this.cryptoService.isSigned(signedId)) {
                        this.logger.error("scroll id [{}] is not signed but is expected to be. nodes [{}], minimum node version [{}]", (Object)signedId, (Object)state.nodes(), (Object)state.nodes().getMinNodeVersion());
                        this.auditTrail.tamperedRequest(user, action, (TransportMessage)request);
                        throw Exceptions.authorizationError("invalid request", new Object[0]);
                    }
                    unsignedIds.add(this.cryptoService.unsignAndVerify(signedId, null));
                    continue;
                }
                if (this.cryptoService.isSigned(signedId)) {
                    unsignedIds.add(this.cryptoService.unsignAndVerify(signedId, null));
                    continue;
                }
                unsignedIds.add(signedId);
            }
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            this.auditTrail.tamperedRequest(user, action, (TransportMessage)request);
            throw Exceptions.authorizationError("invalid request. {}", e.getMessage());
        }
    }

    private <Response extends ActionResponse> Response sign(Response response) throws IOException {
        SearchResponse searchResponse;
        String scrollId;
        boolean sign;
        if (response instanceof SearchResponse && (sign = this.clusterService.state().nodes().getMinNodeVersion().before(Version.V_5_5_0_UNRELEASED)) && (scrollId = (searchResponse = (SearchResponse)response).getScrollId()) != null && !this.cryptoService.isSigned(scrollId)) {
            searchResponse.scrollId(this.cryptoService.sign(scrollId, Version.CURRENT));
        }
        return response;
    }

    private static /* synthetic */ void lambda$apply$1(ActionFilterChain chain, Task task, String action, ActionRequest request, ActionListener signingListener, Void aVoid) throws Exception {
        chain.proceed(task, action, request, signingListener);
    }
}

