/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.persistent;

import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xpack.persistent.PersistentTaskParams;
import org.elasticsearch.xpack.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.xpack.persistent.PersistentTasksExecutor;
import org.elasticsearch.xpack.persistent.PersistentTasksExecutorRegistry;

public class PersistentTasksClusterService
extends AbstractComponent
implements ClusterStateListener {
    private final ClusterService clusterService;
    private final PersistentTasksExecutorRegistry registry;

    public PersistentTasksClusterService(Settings settings, PersistentTasksExecutorRegistry registry, ClusterService clusterService) {
        super(settings);
        this.clusterService = clusterService;
        clusterService.addListener((ClusterStateListener)this);
        this.registry = registry;
    }

    public <Params extends PersistentTaskParams> void createPersistentTask(final String taskId, final String action, final @Nullable Params params, final ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>> listener) {
        this.clusterService.submitStateUpdateTask("create persistent task", (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) throws Exception {
                PersistentTasksCustomMetaData.Builder builder = PersistentTasksClusterService.builder(currentState);
                if (builder.hasTask(taskId)) {
                    throw new ResourceAlreadyExistsException("task with id {" + taskId + "} already exist", new Object[0]);
                }
                PersistentTasksClusterService.this.validate(action, currentState, params);
                PersistentTasksCustomMetaData.Assignment assignment = PersistentTasksClusterService.this.getAssignement(action, currentState, params);
                return PersistentTasksClusterService.update(currentState, builder.addTask(taskId, action, params, assignment));
            }

            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)newState.getMetaData().custom("persistent_tasks");
                if (tasks != null) {
                    listener.onResponse(tasks.getTask(taskId));
                } else {
                    listener.onResponse(null);
                }
            }
        });
    }

    public void completePersistentTask(final String id, final long allocationId, Exception failure, final ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>> listener) {
        String source;
        if (failure != null) {
            this.logger.warn("persistent task " + id + " failed", (Throwable)failure);
            source = "finish persistent task (failed)";
        } else {
            source = "finish persistent task (success)";
        }
        this.clusterService.submitStateUpdateTask(source, (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) throws Exception {
                PersistentTasksCustomMetaData.Builder tasksInProgress = PersistentTasksClusterService.builder(currentState);
                if (tasksInProgress.hasTask(id, allocationId)) {
                    tasksInProgress.finishTask(id);
                    return PersistentTasksClusterService.update(currentState, tasksInProgress);
                }
                if (tasksInProgress.hasTask(id)) {
                    PersistentTasksClusterService.this.logger.warn("The task [{}] with id [{}] was found but it has a different allocation id [{}], status is not updated", (Object)PersistentTasksCustomMetaData.getTaskWithId(currentState, id).getTaskName(), (Object)id, (Object)allocationId);
                } else {
                    PersistentTasksClusterService.this.logger.warn("The task [{}] wasn't found, status is not updated", (Object)id);
                }
                throw new ResourceNotFoundException("the task with id [" + id + "] and allocation id [" + allocationId + "] not found", new Object[0]);
            }

            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse(PersistentTasksCustomMetaData.getTaskWithId(oldState, id));
            }
        });
    }

    public void removePersistentTask(final String id, final ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>> listener) {
        this.clusterService.submitStateUpdateTask("remove persistent task", (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) throws Exception {
                PersistentTasksCustomMetaData.Builder tasksInProgress = PersistentTasksClusterService.builder(currentState);
                if (tasksInProgress.hasTask(id)) {
                    return PersistentTasksClusterService.update(currentState, tasksInProgress.removeTask(id));
                }
                throw new ResourceNotFoundException("the task with id {} doesn't exist", new Object[]{id});
            }

            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse(PersistentTasksCustomMetaData.getTaskWithId(oldState, id));
            }
        });
    }

    public void updatePersistentTaskStatus(final String id, final long allocationId, final Task.Status status, final ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>> listener) {
        this.clusterService.submitStateUpdateTask("update task status", (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) throws Exception {
                PersistentTasksCustomMetaData.Builder tasksInProgress = PersistentTasksClusterService.builder(currentState);
                if (tasksInProgress.hasTask(id, allocationId)) {
                    return PersistentTasksClusterService.update(currentState, tasksInProgress.updateTaskStatus(id, status));
                }
                if (tasksInProgress.hasTask(id)) {
                    PersistentTasksClusterService.this.logger.warn("trying to update status on task {} with unexpected allocation id {}", (Object)id, (Object)allocationId);
                } else {
                    PersistentTasksClusterService.this.logger.warn("trying to update status on non-existing task {}", (Object)id);
                }
                throw new ResourceNotFoundException("the task with id {} and allocation id {} doesn't exist", new Object[]{id, allocationId});
            }

            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse(PersistentTasksCustomMetaData.getTaskWithId(newState, id));
            }
        });
    }

    private <Params extends PersistentTaskParams> PersistentTasksCustomMetaData.Assignment getAssignement(String taskName, ClusterState currentState, @Nullable Params params) {
        PersistentTasksExecutor<Params> persistentTasksExecutor = this.registry.getPersistentTaskExecutorSafe(taskName);
        return persistentTasksExecutor.getAssignment(params, currentState);
    }

    private <Params extends PersistentTaskParams> void validate(String taskName, ClusterState currentState, @Nullable Params params) {
        PersistentTasksExecutor<Params> persistentTasksExecutor = this.registry.getPersistentTaskExecutorSafe(taskName);
        persistentTasksExecutor.validate(params, currentState);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (event.localNodeMaster()) {
            this.logger.trace("checking task reassignment for cluster state {}", (Object)event.state().getVersion());
            if (PersistentTasksClusterService.reassignmentRequired(event, this::getAssignement)) {
                this.logger.trace("task reassignment is needed");
                this.reassignTasks();
            } else {
                this.logger.trace("task reassignment is not needed");
            }
        }
    }

    static boolean reassignmentRequired(ClusterChangedEvent event, ExecutorNodeDecider decider) {
        PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)event.state().getMetaData().custom("persistent_tasks");
        PersistentTasksCustomMetaData prevTasks = (PersistentTasksCustomMetaData)event.previousState().getMetaData().custom("persistent_tasks");
        if (tasks != null && (!Objects.equals((Object)tasks, (Object)prevTasks) || event.nodesChanged() || event.routingTableChanged() || !event.previousState().nodes().isLocalNodeElectedMaster())) {
            boolean reassignmentRequired = false;
            for (PersistentTasksCustomMetaData.PersistentTask<?> taskInProgress : tasks.tasks()) {
                if (!taskInProgress.needsReassignment(event.state().nodes()) || Objects.equals(taskInProgress.getAssignment(), decider.getAssignment(taskInProgress.getTaskName(), event.state(), taskInProgress.getParams()))) continue;
                reassignmentRequired = true;
                break;
            }
            return reassignmentRequired;
        }
        return false;
    }

    public void reassignTasks() {
        this.clusterService.submitStateUpdateTask("reassign persistent tasks", (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) throws Exception {
                return PersistentTasksClusterService.reassignTasks(currentState, PersistentTasksClusterService.this.logger, (x$0, x$1, x$2) -> PersistentTasksClusterService.this.getAssignement(x$0, x$1, x$2));
            }

            public void onFailure(String source, Exception e) {
                PersistentTasksClusterService.this.logger.warn("Unsuccessful persistent task reassignment", (Throwable)e);
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            }
        });
    }

    static ClusterState reassignTasks(ClusterState currentState, Logger logger, ExecutorNodeDecider decider) {
        PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)currentState.getMetaData().custom("persistent_tasks");
        ClusterState clusterState = currentState;
        DiscoveryNodes nodes = currentState.nodes();
        if (tasks != null) {
            logger.trace("reassigning {} persistent tasks", (Object)tasks.tasks().size());
            for (PersistentTasksCustomMetaData.PersistentTask<?> task : tasks.tasks()) {
                if (task.needsReassignment(nodes)) {
                    PersistentTasksCustomMetaData.Assignment assignment = decider.getAssignment(task.getTaskName(), clusterState, task.getParams());
                    if (!Objects.equals(assignment, task.getAssignment())) {
                        logger.trace("reassigning task {} from node {} to node {}", (Object)task.getId(), (Object)task.getAssignment().getExecutorNode(), (Object)assignment.getExecutorNode());
                        clusterState = PersistentTasksClusterService.update(clusterState, PersistentTasksClusterService.builder(clusterState).reassignTask(task.getId(), assignment));
                        continue;
                    }
                    logger.trace("ignoring task {} because assignment is the same {}", (Object)task.getId(), (Object)assignment);
                    continue;
                }
                logger.trace("ignoring task {} because it is still running", (Object)task.getId());
            }
        }
        return clusterState;
    }

    private static PersistentTasksCustomMetaData.Builder builder(ClusterState currentState) {
        return PersistentTasksCustomMetaData.builder((PersistentTasksCustomMetaData)currentState.getMetaData().custom("persistent_tasks"));
    }

    private static ClusterState update(ClusterState currentState, PersistentTasksCustomMetaData.Builder tasksInProgress) {
        if (tasksInProgress.isChanged()) {
            return ClusterState.builder((ClusterState)currentState).metaData(MetaData.builder((MetaData)currentState.metaData()).putCustom("persistent_tasks", (MetaData.Custom)tasksInProgress.build())).build();
        }
        return currentState;
    }

    static interface ExecutorNodeDecider {
        public <Params extends PersistentTaskParams> PersistentTasksCustomMetaData.Assignment getAssignment(String var1, ClusterState var2, Params var3);
    }
}

