/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.collector.ml;

import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.XPackClient;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.ml.action.GetJobsStatsAction;
import org.elasticsearch.xpack.ml.client.MachineLearningClient;
import org.elasticsearch.xpack.monitoring.MonitoringSettings;
import org.elasticsearch.xpack.monitoring.collector.Collector;
import org.elasticsearch.xpack.monitoring.collector.ml.JobStatsMonitoringDoc;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringDoc;
import org.elasticsearch.xpack.security.InternalClient;

public class JobStatsCollector
extends Collector {
    private final MachineLearningClient client;

    public JobStatsCollector(Settings settings, ClusterService clusterService, MonitoringSettings monitoringSettings, XPackLicenseState licenseState, InternalClient client) {
        this(settings, clusterService, monitoringSettings, licenseState, new XPackClient((Client)client).machineLearning());
    }

    JobStatsCollector(Settings settings, ClusterService clusterService, MonitoringSettings monitoringSettings, XPackLicenseState licenseState, MachineLearningClient client) {
        super(settings, "job_stats", clusterService, monitoringSettings, licenseState);
        this.client = client;
    }

    @Override
    protected boolean shouldCollect() {
        return super.shouldCollect() && (Boolean)XPackSettings.MACHINE_LEARNING_ENABLED.get(this.settings) != false && this.licenseState.isMachineLearningAllowed() && this.isLocalNodeMaster();
    }

    protected List<MonitoringDoc> doCollect() throws Exception {
        GetJobsStatsAction.Response jobs = (GetJobsStatsAction.Response)((Object)this.client.getJobsStats(new GetJobsStatsAction.Request("_all")).actionGet(this.monitoringSettings.jobStatsTimeout()));
        long timestamp = System.currentTimeMillis();
        String clusterUuid = this.clusterUUID();
        DiscoveryNode node = this.localNode();
        return jobs.getResponse().results().stream().map(jobStats -> new JobStatsMonitoringDoc(clusterUuid, timestamp, node, (GetJobsStatsAction.Response.JobStats)jobStats)).collect(Collectors.toList());
    }
}

