/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.collector.indices;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequestBuilder;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.monitoring.MonitoringSettings;
import org.elasticsearch.xpack.monitoring.collector.Collector;
import org.elasticsearch.xpack.monitoring.collector.indices.IndexStatsMonitoringDoc;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringDoc;
import org.elasticsearch.xpack.security.InternalClient;

public class IndexStatsCollector
extends Collector {
    private final Client client;

    public IndexStatsCollector(Settings settings, ClusterService clusterService, MonitoringSettings monitoringSettings, XPackLicenseState licenseState, InternalClient client) {
        super(settings, "index-stats", clusterService, monitoringSettings, licenseState);
        this.client = client;
    }

    @Override
    protected boolean shouldCollect() {
        return super.shouldCollect() && this.isLocalNodeMaster();
    }

    @Override
    protected Collection<MonitoringDoc> doCollect() throws Exception {
        ArrayList<IndexStatsMonitoringDoc> results = new ArrayList<IndexStatsMonitoringDoc>();
        IndicesStatsResponse indicesStats = (IndicesStatsResponse)((IndicesStatsRequestBuilder)((IndicesStatsRequestBuilder)this.client.admin().indices().prepareStats(new String[0]).setIndices(this.monitoringSettings.indices())).setIndicesOptions(IndicesOptions.lenientExpandOpen())).clear().setDocs(true).setFieldData(true).setIndexing(true).setMerge(true).setSearch(true).setSegments(true).setStore(true).setRefresh(true).setQueryCache(true).setRequestCache(true).get(this.monitoringSettings.indexStatsTimeout());
        long timestamp = System.currentTimeMillis();
        String clusterUUID = this.clusterUUID();
        DiscoveryNode sourceNode = this.localNode();
        for (IndexStats indexStats : indicesStats.getIndices().values()) {
            results.add(new IndexStatsMonitoringDoc(IndexStatsCollector.monitoringId(), IndexStatsCollector.monitoringVersion(), clusterUUID, timestamp, sourceNode, indexStats));
        }
        return Collections.unmodifiableCollection(results);
    }
}

