/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.collector.cluster;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.util.Supplier;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.action.XPackUsageRequestBuilder;
import org.elasticsearch.xpack.action.XPackUsageResponse;
import org.elasticsearch.xpack.monitoring.MonitoringSettings;
import org.elasticsearch.xpack.monitoring.collector.Collector;
import org.elasticsearch.xpack.monitoring.collector.cluster.ClusterStatsMonitoringDoc;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringDoc;
import org.elasticsearch.xpack.security.InternalClient;

public class ClusterStatsCollector
extends Collector {
    private final LicenseService licenseService;
    private final Client client;

    public ClusterStatsCollector(Settings settings, ClusterService clusterService, MonitoringSettings monitoringSettings, XPackLicenseState licenseState, InternalClient client, LicenseService licenseService) {
        super(settings, "cluster_stats", clusterService, monitoringSettings, licenseState);
        this.client = client;
        this.licenseService = licenseService;
    }

    @Override
    protected boolean shouldCollect() {
        return this.isLocalNodeMaster();
    }

    @Override
    protected Collection<MonitoringDoc> doCollect() throws Exception {
        Supplier clusterStatsSupplier = () -> (ClusterStatsResponse)this.client.admin().cluster().prepareClusterStats().get(this.monitoringSettings.clusterStatsTimeout());
        Supplier usageSupplier = () -> ((XPackUsageResponse)new XPackUsageRequestBuilder((ElasticsearchClient)this.client).get()).getUsages();
        ClusterStatsResponse clusterStats = (ClusterStatsResponse)clusterStatsSupplier.get();
        long timestamp = System.currentTimeMillis();
        String clusterUUID = this.clusterUUID();
        DiscoveryNode sourceNode = this.localNode();
        String clusterName = this.clusterService.getClusterName().value();
        String version = Version.CURRENT.toString();
        ClusterState clusterState = this.clusterService.state();
        License license = this.licenseService.getLicense();
        List usage = (List)this.collect(usageSupplier);
        return Collections.singleton(new ClusterStatsMonitoringDoc(ClusterStatsCollector.monitoringId(), ClusterStatsCollector.monitoringVersion(), clusterUUID, timestamp, sourceNode, clusterName, version, license, usage, clusterStats, clusterState, clusterStats.getStatus()));
    }

    @Nullable
    private <T> T collect(Supplier<T> supplier) {
        try {
            return (T)supplier.get();
        }
        catch (ElasticsearchSecurityException e) {
            if (!LicenseUtils.isLicenseExpiredException(e)) {
                throw e;
            }
            this.logger.trace(() -> new ParameterizedMessage("collector [{}] - unable to collect data because of expired license", (Object)this.name()), (Throwable)e);
            return null;
        }
    }
}

