/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.monitoring.action.MonitoringBulkDoc;
import org.elasticsearch.xpack.monitoring.action.MonitoringBulkRequest;
import org.elasticsearch.xpack.monitoring.action.MonitoringBulkResponse;
import org.elasticsearch.xpack.monitoring.exporter.Exporters;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringDoc;

public class TransportMonitoringBulkAction
extends HandledTransportAction<MonitoringBulkRequest, MonitoringBulkResponse> {
    private final ClusterService clusterService;
    private final Exporters exportService;

    @Inject
    public TransportMonitoringBulkAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Exporters exportService) {
        super(settings, "cluster:admin/xpack/monitoring/bulk", threadPool, transportService, actionFilters, indexNameExpressionResolver, MonitoringBulkRequest::new);
        this.clusterService = clusterService;
        this.exportService = exportService;
    }

    protected void doExecute(MonitoringBulkRequest request, ActionListener<MonitoringBulkResponse> listener) {
        this.clusterService.state().blocks().globalBlockedRaiseException(ClusterBlockLevel.WRITE);
        new AsyncAction(request, listener, this.exportService, this.clusterService).start();
    }

    private MonitoringBulkResponse response(long start) {
        return new MonitoringBulkResponse(this.took(start));
    }

    private MonitoringBulkResponse response(long start, Exception e) {
        return new MonitoringBulkResponse(this.took(start), new MonitoringBulkResponse.Error(e));
    }

    private long took(long start) {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
    }

    class AsyncAction {
        private final MonitoringBulkRequest request;
        private final ActionListener<MonitoringBulkResponse> listener;
        private final Exporters exportService;
        private final ClusterService clusterService;

        AsyncAction(MonitoringBulkRequest request, ActionListener<MonitoringBulkResponse> listener, Exporters exportService, ClusterService clusterService) {
            this.request = request;
            this.listener = listener;
            this.exportService = exportService;
            this.clusterService = clusterService;
        }

        void start() {
            this.executeExport(this.prepareForExport(this.request.getDocs()), System.nanoTime(), this.listener);
        }

        Collection<MonitoringDoc> prepareForExport(Collection<MonitoringBulkDoc> bulkDocs) {
            long defaultTimestamp = System.currentTimeMillis();
            String defaultClusterUUID = this.clusterService.state().metaData().clusterUUID();
            DiscoveryNode discoveryNode = this.clusterService.localNode();
            MonitoringDoc.Node defaultNode = new MonitoringDoc.Node(discoveryNode.getId(), discoveryNode.getHostName(), discoveryNode.getAddress().toString(), discoveryNode.getHostAddress(), discoveryNode.getName(), discoveryNode.getAttributes());
            ArrayList<MonitoringDoc> docs = new ArrayList<MonitoringDoc>();
            for (MonitoringBulkDoc bulkDoc : bulkDocs) {
                String clusterUUID = Strings.hasLength((String)bulkDoc.getClusterUUID()) ? bulkDoc.getClusterUUID() : defaultClusterUUID;
                long timestamp = bulkDoc.getTimestamp() != 0L ? bulkDoc.getTimestamp() : defaultTimestamp;
                MonitoringDoc.Node node = bulkDoc.getSourceNode() != null ? bulkDoc.getSourceNode() : defaultNode;
                docs.add(new MonitoringBulkDoc(bulkDoc.getMonitoringId(), bulkDoc.getMonitoringVersion(), bulkDoc.getIndex(), bulkDoc.getType(), bulkDoc.getId(), clusterUUID, timestamp, node, bulkDoc.getSource(), bulkDoc.getXContentType()));
            }
            return docs;
        }

        void executeExport(Collection<MonitoringDoc> docs, long startTimeNanos, ActionListener<MonitoringBulkResponse> listener) {
            try {
                this.exportService.export(docs, (ActionListener<Void>)ActionListener.wrap(r -> listener.onResponse((Object)TransportMonitoringBulkAction.this.response(startTimeNanos)), e -> listener.onResponse((Object)TransportMonitoringBulkAction.this.response(startTimeNanos, e))));
            }
            catch (Exception e2) {
                listener.onResponse((Object)TransportMonitoringBulkAction.this.response(startTimeNanos, e2));
            }
        }
    }
}

