/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.rounding.DateTimeUnit;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.ml.datafeed.ChunkingConfig;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.messages.Messages;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.utils.MlStrings;
import org.elasticsearch.xpack.ml.utils.time.TimeUtils;
import org.joda.time.DateTimeZone;

public class DatafeedConfig
extends AbstractDiffable<DatafeedConfig>
implements ToXContent {
    public static final ParseField RESULTS_FIELD = new ParseField("datafeeds", new String[0]);
    public static final String DOC_COUNT = "doc_count";
    public static final ParseField ID = new ParseField("datafeed_id", new String[0]);
    public static final ParseField QUERY_DELAY = new ParseField("query_delay", new String[0]);
    public static final ParseField FREQUENCY = new ParseField("frequency", new String[0]);
    public static final ParseField INDEXES = new ParseField("indexes", new String[0]);
    public static final ParseField INDICES = new ParseField("indices", new String[0]);
    public static final ParseField TYPES = new ParseField("types", new String[0]);
    public static final ParseField QUERY = new ParseField("query", new String[0]);
    public static final ParseField SCROLL_SIZE = new ParseField("scroll_size", new String[0]);
    public static final ParseField AGGREGATIONS = new ParseField("aggregations", new String[0]);
    public static final ParseField AGGS = new ParseField("aggs", new String[0]);
    public static final ParseField SCRIPT_FIELDS = new ParseField("script_fields", new String[0]);
    public static final ParseField SOURCE = new ParseField("_source", new String[0]);
    public static final ParseField CHUNKING_CONFIG = new ParseField("chunking_config", new String[0]);
    public static final ObjectParser<Builder, Void> PARSER = new ObjectParser("datafeed_config", Builder::new);
    private final String id;
    private final String jobId;
    private final TimeValue queryDelay;
    private final TimeValue frequency;
    private final List<String> indices;
    private final List<String> types;
    private final QueryBuilder query;
    private final AggregatorFactories.Builder aggregations;
    private final List<SearchSourceBuilder.ScriptField> scriptFields;
    private final Integer scrollSize;
    private final ChunkingConfig chunkingConfig;

    private DatafeedConfig(String id, String jobId, TimeValue queryDelay, TimeValue frequency, List<String> indices, List<String> types, QueryBuilder query, AggregatorFactories.Builder aggregations, List<SearchSourceBuilder.ScriptField> scriptFields, Integer scrollSize, ChunkingConfig chunkingConfig) {
        this.id = id;
        this.jobId = jobId;
        this.queryDelay = queryDelay;
        this.frequency = frequency;
        this.indices = indices;
        this.types = types;
        this.query = query;
        this.aggregations = aggregations;
        this.scriptFields = scriptFields;
        this.scrollSize = scrollSize;
        this.chunkingConfig = chunkingConfig;
    }

    public DatafeedConfig(StreamInput in) throws IOException {
        this.id = in.readString();
        this.jobId = in.readString();
        this.queryDelay = (TimeValue)in.readOptionalWriteable(TimeValue::new);
        this.frequency = (TimeValue)in.readOptionalWriteable(TimeValue::new);
        this.indices = in.readBoolean() ? in.readList(StreamInput::readString) : null;
        this.types = in.readBoolean() ? in.readList(StreamInput::readString) : null;
        this.query = (QueryBuilder)in.readNamedWriteable(QueryBuilder.class);
        this.aggregations = (AggregatorFactories.Builder)in.readOptionalWriteable(AggregatorFactories.Builder::new);
        this.scriptFields = in.readBoolean() ? in.readList(SearchSourceBuilder.ScriptField::new) : null;
        this.scrollSize = in.readOptionalVInt();
        if (in.getVersion().before(Version.V_5_5_0_UNRELEASED)) {
            in.readBoolean();
        }
        this.chunkingConfig = (ChunkingConfig)in.readOptionalWriteable(ChunkingConfig::new);
    }

    public String getId() {
        return this.id;
    }

    public String getJobId() {
        return this.jobId;
    }

    public TimeValue getQueryDelay() {
        return this.queryDelay;
    }

    public TimeValue getFrequency() {
        return this.frequency;
    }

    public List<String> getIndices() {
        return this.indices;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public Integer getScrollSize() {
        return this.scrollSize;
    }

    public QueryBuilder getQuery() {
        return this.query;
    }

    public AggregatorFactories.Builder getAggregations() {
        return this.aggregations;
    }

    public long getHistogramIntervalMillis() {
        return DatafeedConfig.getHistogramIntervalMillis(this.aggregations);
    }

    private static long getHistogramIntervalMillis(AggregatorFactories.Builder aggregations) {
        AggregationBuilder topLevelAgg = DatafeedConfig.getTopLevelAgg(aggregations);
        if (topLevelAgg == null) {
            throw new IllegalStateException("No aggregations exist");
        }
        if (topLevelAgg instanceof HistogramAggregationBuilder) {
            return (long)((HistogramAggregationBuilder)topLevelAgg).interval();
        }
        if (topLevelAgg instanceof DateHistogramAggregationBuilder) {
            return DatafeedConfig.validateAndGetDateHistogramInterval((DateHistogramAggregationBuilder)topLevelAgg);
        }
        throw new IllegalStateException("Invalid top level aggregation [" + topLevelAgg.getName() + "]");
    }

    private static AggregationBuilder getTopLevelAgg(AggregatorFactories.Builder aggregations) {
        if (aggregations == null || aggregations.getAggregatorFactories().isEmpty()) {
            return null;
        }
        return (AggregationBuilder)aggregations.getAggregatorFactories().get(0);
    }

    private static long validateAndGetDateHistogramInterval(DateHistogramAggregationBuilder dateHistogram) {
        if (dateHistogram.timeZone() != null && !dateHistogram.timeZone().equals((Object)DateTimeZone.UTC)) {
            throw ExceptionsHelper.badRequestException("ML requires date_histogram.time_zone to be UTC", new Object[0]);
        }
        if (dateHistogram.dateHistogramInterval() != null) {
            return DatafeedConfig.validateAndGetCalendarInterval(dateHistogram.dateHistogramInterval().toString());
        }
        return (long)dateHistogram.interval();
    }

    private static long validateAndGetCalendarInterval(String calendarInterval) {
        TimeValue interval;
        block10: {
            block9: {
                DateTimeUnit dateTimeUnit = (DateTimeUnit)DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(calendarInterval);
                if (dateTimeUnit == null) break block9;
                switch (dateTimeUnit) {
                    case WEEK_OF_WEEKYEAR: {
                        interval = new TimeValue(7L, TimeUnit.DAYS);
                        break block10;
                    }
                    case DAY_OF_MONTH: {
                        interval = new TimeValue(1L, TimeUnit.DAYS);
                        break block10;
                    }
                    case HOUR_OF_DAY: {
                        interval = new TimeValue(1L, TimeUnit.HOURS);
                        break block10;
                    }
                    case MINUTES_OF_HOUR: {
                        interval = new TimeValue(1L, TimeUnit.MINUTES);
                        break block10;
                    }
                    case SECOND_OF_MINUTE: {
                        interval = new TimeValue(1L, TimeUnit.SECONDS);
                        break block10;
                    }
                    case MONTH_OF_YEAR: 
                    case YEAR_OF_CENTURY: 
                    case QUARTER: {
                        throw ExceptionsHelper.badRequestException(DatafeedConfig.invalidDateHistogramCalendarIntervalMessage(calendarInterval), new Object[0]);
                    }
                    default: {
                        throw ExceptionsHelper.badRequestException("Unexpected dateTimeUnit [" + dateTimeUnit + "]", new Object[0]);
                    }
                }
            }
            interval = TimeValue.parseTimeValue((String)calendarInterval, (String)"date_histogram.interval");
        }
        if (interval.days() > 7L) {
            throw ExceptionsHelper.badRequestException(DatafeedConfig.invalidDateHistogramCalendarIntervalMessage(calendarInterval), new Object[0]);
        }
        return interval.millis();
    }

    private static String invalidDateHistogramCalendarIntervalMessage(String interval) {
        throw ExceptionsHelper.badRequestException("When specifying a date_histogram calendar interval [" + interval + "], ML does not accept intervals longer than a week because of variable lengths of periods greater than a week", new Object[0]);
    }

    public boolean hasAggregations() {
        return this.aggregations != null && this.aggregations.count() > 0;
    }

    public List<SearchSourceBuilder.ScriptField> getScriptFields() {
        return this.scriptFields == null ? Collections.emptyList() : this.scriptFields;
    }

    public ChunkingConfig getChunkingConfig() {
        return this.chunkingConfig;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeString(this.jobId);
        out.writeOptionalWriteable((Writeable)this.queryDelay);
        out.writeOptionalWriteable((Writeable)this.frequency);
        if (this.indices != null) {
            out.writeBoolean(true);
            out.writeStringList(this.indices);
        } else {
            out.writeBoolean(false);
        }
        if (this.types != null) {
            out.writeBoolean(true);
            out.writeStringList(this.types);
        } else {
            out.writeBoolean(false);
        }
        out.writeNamedWriteable((NamedWriteable)this.query);
        out.writeOptionalWriteable((Writeable)this.aggregations);
        if (this.scriptFields != null) {
            out.writeBoolean(true);
            out.writeList(this.scriptFields);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalVInt(this.scrollSize);
        if (out.getVersion().before(Version.V_5_5_0_UNRELEASED)) {
            out.writeBoolean(false);
        }
        out.writeOptionalWriteable((Writeable)this.chunkingConfig);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.doXContentBody(builder, params);
        builder.endObject();
        return builder;
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(ID.getPreferredName(), this.id);
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.field(QUERY_DELAY.getPreferredName(), this.queryDelay.getStringRep());
        if (this.frequency != null) {
            builder.field(FREQUENCY.getPreferredName(), this.frequency.getStringRep());
        }
        builder.field(INDICES.getPreferredName(), this.indices);
        builder.field(TYPES.getPreferredName(), this.types);
        builder.field(QUERY.getPreferredName(), (ToXContent)this.query);
        if (this.aggregations != null) {
            builder.field(AGGREGATIONS.getPreferredName(), (ToXContent)this.aggregations);
        }
        if (this.scriptFields != null) {
            builder.startObject(SCRIPT_FIELDS.getPreferredName());
            for (SearchSourceBuilder.ScriptField scriptField : this.scriptFields) {
                scriptField.toXContent(builder, params);
            }
            builder.endObject();
        }
        builder.field(SCROLL_SIZE.getPreferredName(), this.scrollSize);
        if (this.chunkingConfig != null) {
            builder.field(CHUNKING_CONFIG.getPreferredName(), (ToXContent)this.chunkingConfig);
        }
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DatafeedConfig)) {
            return false;
        }
        DatafeedConfig that = (DatafeedConfig)((Object)other);
        return Objects.equals(this.id, that.id) && Objects.equals(this.jobId, that.jobId) && Objects.equals(this.frequency, that.frequency) && Objects.equals(this.queryDelay, that.queryDelay) && Objects.equals(this.indices, that.indices) && Objects.equals(this.types, that.types) && Objects.equals(this.query, that.query) && Objects.equals(this.scrollSize, that.scrollSize) && Objects.equals(this.aggregations, that.aggregations) && Objects.equals(this.scriptFields, that.scriptFields) && Objects.equals((Object)this.chunkingConfig, (Object)that.chunkingConfig);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.jobId, this.frequency, this.queryDelay, this.indices, this.types, this.query, this.scrollSize, this.aggregations, this.scriptFields, this.chunkingConfig});
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareString(Builder::setId, ID);
        PARSER.declareString(Builder::setJobId, Job.ID);
        PARSER.declareStringArray(Builder::setIndices, INDEXES);
        PARSER.declareStringArray(Builder::setIndices, INDICES);
        PARSER.declareStringArray(Builder::setTypes, TYPES);
        PARSER.declareString((builder, val) -> builder.setQueryDelay(TimeValue.parseTimeValue((String)val, (String)QUERY_DELAY.getPreferredName())), QUERY_DELAY);
        PARSER.declareString((builder, val) -> builder.setFrequency(TimeValue.parseTimeValue((String)val, (String)FREQUENCY.getPreferredName())), FREQUENCY);
        PARSER.declareObject(Builder::setQuery, (p, c) -> (QueryBuilder)new QueryParseContext(p).parseInnerQueryBuilder().get(), QUERY);
        PARSER.declareObject(Builder::setAggregations, (p, c) -> AggregatorFactories.parseAggregators((QueryParseContext)new QueryParseContext(p)), AGGREGATIONS);
        PARSER.declareObject(Builder::setAggregations, (p, c) -> AggregatorFactories.parseAggregators((QueryParseContext)new QueryParseContext(p)), AGGS);
        PARSER.declareObject(Builder::setScriptFields, (p, c) -> {
            ArrayList<SearchSourceBuilder.ScriptField> parsedScriptFields = new ArrayList<SearchSourceBuilder.ScriptField>();
            while (p.nextToken() != XContentParser.Token.END_OBJECT) {
                parsedScriptFields.add(new SearchSourceBuilder.ScriptField(new QueryParseContext(p)));
            }
            parsedScriptFields.sort(Comparator.comparing(SearchSourceBuilder.ScriptField::fieldName));
            return parsedScriptFields;
        }, SCRIPT_FIELDS);
        PARSER.declareInt(Builder::setScrollSize, SCROLL_SIZE);
        PARSER.declareBoolean((builder, value) -> {}, SOURCE);
        PARSER.declareObject(Builder::setChunkingConfig, ChunkingConfig.PARSER, CHUNKING_CONFIG);
    }

    public static class Builder {
        private static final int DEFAULT_SCROLL_SIZE = 1000;
        private static final TimeValue DEFAULT_QUERY_DELAY = TimeValue.timeValueMinutes((long)1L);
        private static final int DEFAULT_AGGREGATION_CHUNKING_BUCKETS = 1000;
        private String id;
        private String jobId;
        private TimeValue queryDelay = DEFAULT_QUERY_DELAY;
        private TimeValue frequency;
        private List<String> indices = Collections.emptyList();
        private List<String> types = Collections.emptyList();
        private QueryBuilder query = QueryBuilders.matchAllQuery();
        private AggregatorFactories.Builder aggregations;
        private List<SearchSourceBuilder.ScriptField> scriptFields;
        private Integer scrollSize = 1000;
        private ChunkingConfig chunkingConfig;

        public Builder() {
        }

        public Builder(String id, String jobId) {
            this();
            this.id = ExceptionsHelper.requireNonNull(id, ID.getPreferredName());
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
        }

        public Builder(DatafeedConfig config) {
            this.id = config.id;
            this.jobId = config.jobId;
            this.queryDelay = config.queryDelay;
            this.frequency = config.frequency;
            this.indices = config.indices;
            this.types = config.types;
            this.query = config.query;
            this.aggregations = config.aggregations;
            this.scriptFields = config.scriptFields;
            this.scrollSize = config.scrollSize;
            this.chunkingConfig = config.chunkingConfig;
        }

        public void setId(String datafeedId) {
            this.id = ExceptionsHelper.requireNonNull(datafeedId, ID.getPreferredName());
        }

        public void setJobId(String jobId) {
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
        }

        public void setIndices(List<String> indices) {
            this.indices = ExceptionsHelper.requireNonNull(indices, INDICES.getPreferredName());
        }

        public void setTypes(List<String> types) {
            this.types = ExceptionsHelper.requireNonNull(types, TYPES.getPreferredName());
        }

        public void setQueryDelay(TimeValue queryDelay) {
            TimeUtils.checkNonNegativeMultiple(queryDelay, TimeUnit.MILLISECONDS, QUERY_DELAY);
            this.queryDelay = queryDelay;
        }

        public void setFrequency(TimeValue frequency) {
            TimeUtils.checkPositiveMultiple(frequency, TimeUnit.SECONDS, FREQUENCY);
            this.frequency = frequency;
        }

        public void setQuery(QueryBuilder query) {
            this.query = ExceptionsHelper.requireNonNull(query, QUERY.getPreferredName());
        }

        public void setAggregations(AggregatorFactories.Builder aggregations) {
            this.aggregations = aggregations;
        }

        public void setScriptFields(List<SearchSourceBuilder.ScriptField> scriptFields) {
            ArrayList<SearchSourceBuilder.ScriptField> sorted = new ArrayList<SearchSourceBuilder.ScriptField>();
            for (SearchSourceBuilder.ScriptField scriptField : scriptFields) {
                sorted.add(scriptField);
            }
            sorted.sort(Comparator.comparing(SearchSourceBuilder.ScriptField::fieldName));
            this.scriptFields = sorted;
        }

        public void setScrollSize(int scrollSize) {
            if (scrollSize < 0) {
                String msg = Messages.getMessage("Invalid {0} value ''{1}'' in datafeed configuration", SCROLL_SIZE.getPreferredName(), scrollSize);
                throw ExceptionsHelper.badRequestException(msg, new Object[0]);
            }
            this.scrollSize = scrollSize;
        }

        public void setChunkingConfig(ChunkingConfig chunkingConfig) {
            this.chunkingConfig = chunkingConfig;
        }

        public DatafeedConfig build() {
            ExceptionsHelper.requireNonNull(this.id, ID.getPreferredName());
            ExceptionsHelper.requireNonNull(this.jobId, Job.ID.getPreferredName());
            if (!MlStrings.isValidId(this.id)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("Invalid {0}; ''{1}'' can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; must start and end with alphanumeric", ID.getPreferredName()), new Object[0]);
            }
            if (this.indices == null || this.indices.isEmpty() || this.indices.contains(null) || this.indices.contains("")) {
                throw Builder.invalidOptionValue(INDICES.getPreferredName(), this.indices);
            }
            if (this.types == null || this.types.contains(null) || this.types.contains("")) {
                throw Builder.invalidOptionValue(TYPES.getPreferredName(), this.types);
            }
            this.validateAggregations();
            this.setDefaultChunkingConfig();
            return new DatafeedConfig(this.id, this.jobId, this.queryDelay, this.frequency, this.indices, this.types, this.query, this.aggregations, this.scriptFields, this.scrollSize, this.chunkingConfig);
        }

        private void validateAggregations() {
            if (this.aggregations == null) {
                return;
            }
            if (this.scriptFields != null && !this.scriptFields.isEmpty()) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("script_fields cannot be used in combination with aggregations"), new Object[0]);
            }
            List aggregatorFactories = this.aggregations.getAggregatorFactories();
            if (aggregatorFactories.isEmpty()) {
                throw ExceptionsHelper.badRequestException("A top level date_histogram (or histogram) aggregation is required", new Object[0]);
            }
            AggregationBuilder topLevelAgg = (AggregationBuilder)aggregatorFactories.get(0);
            if (topLevelAgg instanceof HistogramAggregationBuilder) {
                if (((HistogramAggregationBuilder)topLevelAgg).interval() <= 0.0) {
                    throw ExceptionsHelper.badRequestException("Aggregation interval must be greater than 0", new Object[0]);
                }
            } else if (topLevelAgg instanceof DateHistogramAggregationBuilder) {
                if (DatafeedConfig.validateAndGetDateHistogramInterval((DateHistogramAggregationBuilder)topLevelAgg) <= 0L) {
                    throw ExceptionsHelper.badRequestException("Aggregation interval must be greater than 0", new Object[0]);
                }
            } else {
                throw ExceptionsHelper.badRequestException("A top level date_histogram (or histogram) aggregation is required", new Object[0]);
            }
        }

        private void setDefaultChunkingConfig() {
            if (this.chunkingConfig == null) {
                if (this.aggregations == null) {
                    this.chunkingConfig = ChunkingConfig.newAuto();
                } else {
                    long histogramIntervalMillis = DatafeedConfig.getHistogramIntervalMillis(this.aggregations);
                    this.chunkingConfig = ChunkingConfig.newManual(TimeValue.timeValueMillis((long)(1000L * histogramIntervalMillis)));
                }
            }
        }

        private static ElasticsearchException invalidOptionValue(String fieldName, Object value) {
            String msg = Messages.getMessage("Invalid {0} value ''{1}'' in datafeed configuration", fieldName, value);
            throw ExceptionsHelper.badRequestException(msg, new Object[0]);
        }
    }
}

