/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeOperationRequestBuilder;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.config.DataDescription;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.messages.Messages;

public class PutJobAction
extends Action<Request, Response, RequestBuilder> {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(PutJobAction.class));
    public static final PutJobAction INSTANCE = new PutJobAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/put";

    private PutJobAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class TransportAction
    extends TransportMasterNodeAction<Request, Response> {
        private final JobManager jobManager;
        private final XPackLicenseState licenseState;

        @Inject
        public TransportAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, XPackLicenseState licenseState, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, JobManager jobManager) {
            super(settings, PutJobAction.NAME, transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, Request::new);
            this.licenseState = licenseState;
            this.jobManager = jobManager;
        }

        protected String executor() {
            return "same";
        }

        protected Response newResponse() {
            return new Response();
        }

        protected void masterOperation(Request request, ClusterState state, ActionListener<Response> listener) throws Exception {
            this.jobManager.putJob(request, state, listener);
        }

        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }

        protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
            if (this.licenseState.isMachineLearningAllowed()) {
                super.doExecute(task, (MasterNodeRequest)request, listener);
            } else {
                listener.onFailure((Exception)((Object)LicenseUtils.newComplianceException("ml")));
            }
        }
    }

    public static class Response
    extends AcknowledgedResponse
    implements ToXContentObject {
        private Job job;

        public Response(boolean acked, Job job) {
            super(acked);
            this.job = job;
        }

        Response() {
        }

        public Job getResponse() {
            return this.job;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.readAcknowledged(in);
            this.job = new Job(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.writeAcknowledged(out);
            this.job.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.job.doXContentBody(builder, params);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals((Object)this.job, (Object)response.job);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.job});
        }
    }

    public static class RequestBuilder
    extends MasterNodeOperationRequestBuilder<Request, Response, RequestBuilder> {
        public RequestBuilder(ElasticsearchClient client, PutJobAction action) {
            super(client, (Action)action, (MasterNodeRequest)new Request());
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements ToXContent {
        private Job.Builder jobBuilder;

        public static Request parseRequest(String jobId, XContentParser parser) {
            Job.Builder jobBuilder = (Job.Builder)Job.PARSER.apply(parser, null);
            if (jobBuilder.getId() == null) {
                jobBuilder.setId(jobId);
            } else if (!Strings.isNullOrEmpty((String)jobId) && !jobId.equals(jobBuilder.getId())) {
                throw new IllegalArgumentException(Messages.getMessage("Inconsistent {0}; ''{1}'' specified in the body differs from ''{2}'' specified as a URL argument", Job.ID.getPreferredName(), jobBuilder.getId(), jobId));
            }
            List<String> invalidJobCreationSettings = jobBuilder.invalidCreateTimeSettings();
            if (!invalidJobCreationSettings.isEmpty()) {
                throw new IllegalArgumentException(Messages.getMessage("The job is configured with fields [{0}] that are illegal to set at job creation", String.join((CharSequence)",", invalidJobCreationSettings)));
            }
            return new Request(jobBuilder);
        }

        public Request(Job.Builder jobBuilder) {
            jobBuilder.validateInputFields();
            this.jobBuilder = jobBuilder;
        }

        Request() {
        }

        public Job.Builder getJobBuilder() {
            return this.jobBuilder;
        }

        public ActionRequestValidationException validate() {
            if (this.jobBuilder != null && this.jobBuilder.getDataDescription() != null && this.jobBuilder.getDataDescription().getFormat() == DataDescription.DataFormat.DELIMITED) {
                DEPRECATION_LOGGER.deprecated("Creating jobs with delimited data format is deprecated. Please use JSON instead.", new Object[0]);
            }
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.jobBuilder = new Job.Builder(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.jobBuilder.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.jobBuilder.toXContent(builder, params);
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.jobBuilder, request.jobBuilder);
        }

        public int hashCode() {
            return Objects.hash(this.jobBuilder);
        }

        public final String toString() {
            return Strings.toString((ToXContent)this);
        }
    }
}

