/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ml.MlMetadata;
import org.elasticsearch.xpack.ml.action.OpenJobAction;
import org.elasticsearch.xpack.ml.action.util.QueryPage;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.config.JobState;
import org.elasticsearch.xpack.ml.job.persistence.JobProvider;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.persistent.PersistentTasksCustomMetaData;

public class GetJobsStatsAction
extends Action<Request, Response, RequestBuilder> {
    public static final GetJobsStatsAction INSTANCE = new GetJobsStatsAction();
    public static final String NAME = "cluster:monitor/xpack/ml/job/stats/get";
    private static final String DATA_COUNTS = "data_counts";
    private static final String MODEL_SIZE_STATS = "model_size_stats";
    private static final String STATE = "state";
    private static final String NODE = "node";

    private GetJobsStatsAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class TransportAction
    extends TransportTasksAction<OpenJobAction.JobTask, Request, Response, QueryPage<Response.JobStats>> {
        private final ClusterService clusterService;
        private final AutodetectProcessManager processManager;
        private final JobProvider jobProvider;

        @Inject
        public TransportAction(Settings settings, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, AutodetectProcessManager processManager, JobProvider jobProvider) {
            super(settings, GetJobsStatsAction.NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, Request::new, Response::new, "management");
            this.clusterService = clusterService;
            this.processManager = processManager;
            this.jobProvider = jobProvider;
        }

        protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
            MlMetadata mlMetadata;
            MlMetadata clusterMlMetadata = (MlMetadata)this.clusterService.state().metaData().custom("ml");
            MlMetadata mlMetadata2 = mlMetadata = clusterMlMetadata == null ? MlMetadata.EMPTY_METADATA : clusterMlMetadata;
            if ("_all".equals(request.getJobId())) {
                request.expandedJobsIds = new ArrayList<String>(mlMetadata.getJobs().keySet());
            } else if (!mlMetadata.getJobs().containsKey(request.getJobId())) {
                throw ExceptionsHelper.missingJobException(request.getJobId());
            }
            ActionListener finalListener = listener;
            listener = ActionListener.wrap(response -> this.gatherStatsForClosedJobs(mlMetadata, request, (Response)((Object)response), (ActionListener<Response>)finalListener), arg_0 -> listener.onFailure(arg_0));
            super.doExecute(task, (BaseTasksRequest)request, listener);
        }

        protected Response newResponse(Request request, List<QueryPage<Response.JobStats>> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
            ArrayList<Response.JobStats> stats = new ArrayList<Response.JobStats>();
            for (QueryPage<Response.JobStats> task : tasks) {
                stats.addAll(task.results());
            }
            return new Response(taskOperationFailures, failedNodeExceptions, new QueryPage<Response.JobStats>(stats, stats.size(), Job.RESULTS_FIELD));
        }

        protected QueryPage<Response.JobStats> readTaskResponse(StreamInput in) throws IOException {
            return new QueryPage<Response.JobStats>(in, Response.JobStats::new);
        }

        protected void taskOperation(Request request, OpenJobAction.JobTask task, ActionListener<QueryPage<Response.JobStats>> listener) {
            String jobId = task.getJobId();
            this.logger.debug("Get stats for job [{}]", (Object)jobId);
            ClusterState state = this.clusterService.state();
            PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)state.getMetaData().custom("persistent_tasks");
            Optional<Tuple<DataCounts, ModelSizeStats>> stats = this.processManager.getStatistics(task);
            if (stats.isPresent()) {
                PersistentTasksCustomMetaData.PersistentTask<?> pTask = MlMetadata.getJobTask(jobId, tasks);
                DiscoveryNode node = state.nodes().get(pTask.getExecutorNode());
                JobState jobState = MlMetadata.getJobState(jobId, tasks);
                String assignmentExplanation = pTask.getAssignment().getExplanation();
                TimeValue openTime = TransportAction.durationToTimeValue(this.processManager.jobOpenTime(task));
                Response.JobStats jobStats = new Response.JobStats(jobId, (DataCounts)((Object)stats.get().v1()), (ModelSizeStats)((Object)stats.get().v2()), jobState, node, assignmentExplanation, openTime);
                listener.onResponse(new QueryPage<Response.JobStats>(Collections.singletonList(jobStats), 1L, Job.RESULTS_FIELD));
            } else {
                listener.onResponse(new QueryPage(Collections.emptyList(), 0L, Job.RESULTS_FIELD));
            }
        }

        void gatherStatsForClosedJobs(MlMetadata mlMetadata, Request request, Response response, ActionListener<Response> listener) {
            List<String> jobIds = TransportAction.determineNonDeletedJobIdsWithoutLiveStats(mlMetadata, request.expandedJobsIds, response.jobsStats.results());
            if (jobIds.isEmpty()) {
                listener.onResponse((Object)response);
                return;
            }
            AtomicInteger counter = new AtomicInteger(jobIds.size());
            AtomicArray jobStats = new AtomicArray(jobIds.size());
            PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)this.clusterService.state().getMetaData().custom("persistent_tasks");
            for (int i = 0; i < jobIds.size(); ++i) {
                int slot = i;
                String jobId = jobIds.get(i);
                this.gatherDataCountsAndModelSizeStats(jobId, (dataCounts, modelSizeStats) -> {
                    JobState jobState = MlMetadata.getJobState(jobId, tasks);
                    PersistentTasksCustomMetaData.PersistentTask<?> pTask = MlMetadata.getJobTask(jobId, tasks);
                    String assignmentExplanation = null;
                    if (pTask != null) {
                        assignmentExplanation = pTask.getAssignment().getExplanation();
                    }
                    jobStats.set(slot, (Object)new Response.JobStats(jobId, (DataCounts)((Object)dataCounts), (ModelSizeStats)((Object)modelSizeStats), jobState, null, assignmentExplanation, null));
                    if (counter.decrementAndGet() == 0) {
                        List<Response.JobStats> results = response.getResponse().results();
                        results.addAll(jobStats.asList());
                        listener.onResponse((Object)new Response(response.getTaskFailures(), response.getNodeFailures(), new QueryPage<Response.JobStats>(results, results.size(), Job.RESULTS_FIELD)));
                    }
                }, arg_0 -> listener.onFailure(arg_0));
            }
        }

        void gatherDataCountsAndModelSizeStats(String jobId, BiConsumer<DataCounts, ModelSizeStats> handler, Consumer<Exception> errorHandler) {
            this.jobProvider.dataCounts(jobId, dataCounts -> this.jobProvider.modelSizeStats(jobId, modelSizeStats -> handler.accept((DataCounts)((Object)dataCounts), (ModelSizeStats)((Object)modelSizeStats)), errorHandler), errorHandler);
        }

        static TimeValue durationToTimeValue(Optional<Duration> duration) {
            if (duration.isPresent()) {
                return TimeValue.timeValueSeconds((long)duration.get().getSeconds());
            }
            return null;
        }

        static List<String> determineNonDeletedJobIdsWithoutLiveStats(MlMetadata mlMetadata, List<String> requestedJobIds, List<Response.JobStats> stats) {
            Set excludeJobIds = stats.stream().map(Response.JobStats::getJobId).collect(Collectors.toSet());
            return requestedJobIds.stream().filter(jobId -> !excludeJobIds.contains(jobId) && !mlMetadata.isJobDeleted((String)jobId)).collect(Collectors.toList());
        }
    }

    public static class Response
    extends BaseTasksResponse
    implements ToXContentObject {
        private QueryPage<JobStats> jobsStats;

        public Response(QueryPage<JobStats> jobsStats) {
            super(Collections.emptyList(), Collections.emptyList());
            this.jobsStats = jobsStats;
        }

        Response(List<TaskOperationFailure> taskFailures, List<? extends FailedNodeException> nodeFailures, QueryPage<JobStats> jobsStats) {
            super(taskFailures, nodeFailures);
            this.jobsStats = jobsStats;
        }

        public Response() {
            super(Collections.emptyList(), Collections.emptyList());
        }

        public QueryPage<JobStats> getResponse() {
            return this.jobsStats;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.jobsStats = new QueryPage(in, JobStats::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.jobsStats.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.jobsStats.doXContentBody(builder, params);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.jobsStats});
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(this.jobsStats, other.jobsStats);
        }

        public final String toString() {
            return Strings.toString((ToXContent)this);
        }

        public static class JobStats
        implements ToXContent,
        Writeable {
            private final String jobId;
            private DataCounts dataCounts;
            @Nullable
            private ModelSizeStats modelSizeStats;
            @Nullable
            private TimeValue openTime;
            private JobState state;
            @Nullable
            private DiscoveryNode node;
            @Nullable
            private String assignmentExplanation;

            public JobStats(String jobId, DataCounts dataCounts, @Nullable ModelSizeStats modelSizeStats, JobState state, @Nullable DiscoveryNode node, @Nullable String assignmentExplanation, @Nullable TimeValue opentime) {
                this.jobId = Objects.requireNonNull(jobId);
                this.dataCounts = Objects.requireNonNull(dataCounts);
                this.modelSizeStats = modelSizeStats;
                this.state = Objects.requireNonNull(state);
                this.node = node;
                this.assignmentExplanation = assignmentExplanation;
                this.openTime = opentime;
            }

            JobStats(StreamInput in) throws IOException {
                this.jobId = in.readString();
                this.dataCounts = new DataCounts(in);
                this.modelSizeStats = (ModelSizeStats)in.readOptionalWriteable(ModelSizeStats::new);
                this.state = JobState.fromStream(in);
                this.node = (DiscoveryNode)in.readOptionalWriteable(DiscoveryNode::new);
                this.assignmentExplanation = in.readOptionalString();
                this.openTime = (TimeValue)in.readOptionalWriteable(TimeValue::new);
            }

            public String getJobId() {
                return this.jobId;
            }

            public DataCounts getDataCounts() {
                return this.dataCounts;
            }

            public ModelSizeStats getModelSizeStats() {
                return this.modelSizeStats;
            }

            public JobState getState() {
                return this.state;
            }

            public DiscoveryNode getNode() {
                return this.node;
            }

            public String getAssignmentExplanation() {
                return this.assignmentExplanation;
            }

            public TimeValue getOpenTime() {
                return this.openTime;
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                this.toUnwrappedXContent(builder);
                return builder.endObject();
            }

            public XContentBuilder toUnwrappedXContent(XContentBuilder builder) throws IOException {
                builder.field(Job.ID.getPreferredName(), this.jobId);
                builder.field(GetJobsStatsAction.DATA_COUNTS, (ToXContent)this.dataCounts);
                if (this.modelSizeStats != null) {
                    builder.field(GetJobsStatsAction.MODEL_SIZE_STATS, (ToXContent)this.modelSizeStats);
                }
                builder.field(GetJobsStatsAction.STATE, this.state.toString());
                if (this.node != null) {
                    builder.startObject(GetJobsStatsAction.NODE);
                    builder.field("id", this.node.getId());
                    builder.field("name", this.node.getName());
                    builder.field("ephemeral_id", this.node.getEphemeralId());
                    builder.field("transport_address", this.node.getAddress().toString());
                    builder.startObject("attributes");
                    for (Map.Entry entry : this.node.getAttributes().entrySet()) {
                        builder.field((String)entry.getKey(), (String)entry.getValue());
                    }
                    builder.endObject();
                    builder.endObject();
                }
                if (this.assignmentExplanation != null) {
                    builder.field("assignment_explanation", this.assignmentExplanation);
                }
                if (this.openTime != null) {
                    builder.field("open_time", this.openTime.getStringRep());
                }
                return builder;
            }

            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.jobId);
                this.dataCounts.writeTo(out);
                out.writeOptionalWriteable((Writeable)this.modelSizeStats);
                this.state.writeTo(out);
                out.writeOptionalWriteable((Writeable)this.node);
                out.writeOptionalString(this.assignmentExplanation);
                out.writeOptionalWriteable((Writeable)this.openTime);
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.jobId, this.dataCounts, this.modelSizeStats, this.state, this.node, this.assignmentExplanation, this.openTime});
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                JobStats other = (JobStats)obj;
                return Objects.equals(this.jobId, other.jobId) && Objects.equals((Object)this.dataCounts, (Object)other.dataCounts) && Objects.equals((Object)this.modelSizeStats, (Object)other.modelSizeStats) && Objects.equals((Object)this.state, (Object)other.state) && Objects.equals(this.node, other.node) && Objects.equals(this.assignmentExplanation, other.assignmentExplanation) && Objects.equals(this.openTime, other.openTime);
            }
        }
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, Response, RequestBuilder> {
        public RequestBuilder(ElasticsearchClient client, GetJobsStatsAction action) {
            super(client, (Action)action, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends BaseTasksRequest<Request> {
        private String jobId;
        private List<String> expandedJobsIds;

        public Request(String jobId) {
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
            this.expandedJobsIds = Collections.singletonList(jobId);
        }

        Request() {
        }

        public String getJobId() {
            return this.jobId;
        }

        public boolean match(Task task) {
            return this.jobId.equals("_all") || OpenJobAction.JobTask.match(task, this.jobId);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.jobId = in.readString();
            this.expandedJobsIds = in.readList(StreamInput::readString);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.jobId);
            out.writeStringList(this.expandedJobsIds);
        }

        public int hashCode() {
            return Objects.hash(this.jobId);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.jobId, other.jobId);
        }
    }
}

