/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeOperationRequestBuilder;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ml.MlMetadata;
import org.elasticsearch.xpack.ml.action.IsolateDatafeedAction;
import org.elasticsearch.xpack.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.xpack.persistent.PersistentTasksService;
import org.elasticsearch.xpack.security.InternalClient;

public class DeleteDatafeedAction
extends Action<Request, Response, RequestBuilder> {
    public static final DeleteDatafeedAction INSTANCE = new DeleteDatafeedAction();
    public static final String NAME = "cluster:admin/xpack/ml/datafeeds/delete";

    private DeleteDatafeedAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class TransportAction
    extends TransportMasterNodeAction<Request, Response> {
        private InternalClient client;
        private PersistentTasksService persistentTasksService;

        @Inject
        public TransportAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, InternalClient internalClient, PersistentTasksService persistentTasksService) {
            super(settings, DeleteDatafeedAction.NAME, transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, Request::new);
            this.client = internalClient;
            this.persistentTasksService = persistentTasksService;
        }

        protected String executor() {
            return "same";
        }

        protected Response newResponse() {
            return new Response();
        }

        protected void masterOperation(Request request, ClusterState state, ActionListener<Response> listener) throws Exception {
            if (request.isForce()) {
                this.forceDeleteDatafeed(request, state, listener);
            } else {
                this.deleteDatafeedFromMetadata(request, listener);
            }
        }

        private void forceDeleteDatafeed(Request request, ClusterState state, ActionListener<Response> listener) {
            ActionListener finalListener = ActionListener.wrap(response -> this.deleteDatafeedFromMetadata(request, listener), arg_0 -> listener.onFailure(arg_0));
            ActionListener isolateDatafeedHandler = ActionListener.wrap(response -> this.removeDatafeedTask(request, state, (ActionListener<Boolean>)finalListener), arg_0 -> listener.onFailure(arg_0));
            IsolateDatafeedAction.Request isolateDatafeedRequest = new IsolateDatafeedAction.Request(request.getDatafeedId());
            this.client.execute(IsolateDatafeedAction.INSTANCE, (ActionRequest)isolateDatafeedRequest, isolateDatafeedHandler);
        }

        private void removeDatafeedTask(Request request, ClusterState state, final ActionListener<Boolean> listener) {
            PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)state.getMetaData().custom("persistent_tasks");
            PersistentTasksCustomMetaData.PersistentTask<?> datafeedTask = MlMetadata.getDatafeedTask(request.getDatafeedId(), tasks);
            if (datafeedTask == null) {
                listener.onResponse((Object)true);
            } else {
                this.persistentTasksService.cancelPersistentTask(datafeedTask.getId(), new ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>>(){

                    public void onResponse(PersistentTasksCustomMetaData.PersistentTask<?> persistentTask) {
                        listener.onResponse((Object)Boolean.TRUE);
                    }

                    public void onFailure(Exception e) {
                        if (e instanceof ResourceNotFoundException) {
                            listener.onResponse((Object)true);
                        } else {
                            listener.onFailure(e);
                        }
                    }
                });
            }
        }

        private void deleteDatafeedFromMetadata(final Request request, ActionListener<Response> listener) {
            this.clusterService.submitStateUpdateTask("delete-datafeed-" + request.getDatafeedId(), (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<Response>((AckedRequest)request, listener){

                protected Response newResponse(boolean acknowledged) {
                    return new Response(acknowledged);
                }

                public ClusterState execute(ClusterState currentState) throws Exception {
                    MlMetadata currentMetadata = (MlMetadata)currentState.getMetaData().custom("ml");
                    PersistentTasksCustomMetaData persistentTasks = (PersistentTasksCustomMetaData)currentState.getMetaData().custom("persistent_tasks");
                    MlMetadata newMetadata = new MlMetadata.Builder(currentMetadata).removeDatafeed(request.getDatafeedId(), persistentTasks).build();
                    return ClusterState.builder((ClusterState)currentState).metaData(MetaData.builder((MetaData)currentState.getMetaData()).putCustom("ml", (MetaData.Custom)newMetadata).build()).build();
                }
            });
        }

        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }
    }

    public static class Response
    extends AcknowledgedResponse {
        private Response() {
        }

        private Response(boolean acknowledged) {
            super(acknowledged);
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.readAcknowledged(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.writeAcknowledged(out);
        }
    }

    public static class RequestBuilder
    extends MasterNodeOperationRequestBuilder<Request, Response, RequestBuilder> {
        public RequestBuilder(ElasticsearchClient client, DeleteDatafeedAction action) {
            super(client, (Action)action, (MasterNodeRequest)new Request());
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements ToXContent {
        public static final ParseField FORCE = new ParseField("force", new String[0]);
        private String datafeedId;
        private boolean force;

        public Request(String datafeedId) {
            this.datafeedId = ExceptionsHelper.requireNonNull(datafeedId, DatafeedConfig.ID.getPreferredName());
        }

        Request() {
        }

        public String getDatafeedId() {
            return this.datafeedId;
        }

        public boolean isForce() {
            return this.force;
        }

        public void setForce(boolean force) {
            this.force = force;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.datafeedId = in.readString();
            if (in.getVersion().onOrAfter(Version.V_5_5_0_UNRELEASED)) {
                this.force = in.readBoolean();
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.datafeedId);
            if (out.getVersion().onOrAfter(Version.V_5_5_0_UNRELEASED)) {
                out.writeBoolean(this.force);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(DatafeedConfig.ID.getPreferredName(), this.datafeedId);
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request other = (Request)((Object)o);
            return Objects.equals(this.datafeedId, other.datafeedId) && Objects.equals(this.force, other.force);
        }

        public int hashCode() {
            return Objects.hash(this.datafeedId, this.force);
        }
    }
}

