/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.io.IOException;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.ml.MachineLearningFeatureSet;
import org.elasticsearch.xpack.ml.datafeed.DatafeedManager;
import org.elasticsearch.xpack.ml.job.process.NativeController;
import org.elasticsearch.xpack.ml.job.process.NativeControllerHolder;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;

public class MlLifeCycleService
extends AbstractComponent {
    private final DatafeedManager datafeedManager;
    private final AutodetectProcessManager autodetectProcessManager;

    public MlLifeCycleService(Settings settings, ClusterService clusterService) {
        this(settings, clusterService, null, null);
    }

    public MlLifeCycleService(Settings settings, ClusterService clusterService, DatafeedManager datafeedManager, AutodetectProcessManager autodetectProcessManager) {
        super(settings);
        this.datafeedManager = datafeedManager;
        this.autodetectProcessManager = autodetectProcessManager;
        clusterService.addLifecycleListener(new LifecycleListener(){

            public void beforeStop() {
                MlLifeCycleService.this.stop();
            }
        });
    }

    public synchronized void stop() {
        try {
            if (MachineLearningFeatureSet.isRunningOnMlPlatform(false)) {
                NativeController nativeController;
                if (this.datafeedManager != null) {
                    this.datafeedManager.isolateAllDatafeedsOnThisNode();
                }
                if ((nativeController = NativeControllerHolder.getNativeController(this.settings)) != null) {
                    if (this.autodetectProcessManager != null) {
                        this.autodetectProcessManager.killAllProcessesOnThisNode();
                    }
                    nativeController.stop();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

