/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.MlMetaIndex;
import org.elasticsearch.xpack.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.ml.job.persistence.ElasticsearchMappings;
import org.elasticsearch.xpack.ml.notifications.AuditMessage;

public class MachineLearningTemplateRegistry
extends AbstractComponent
implements ClusterStateListener {
    private static final String ASYNC = "async";
    private final Client client;
    private final ThreadPool threadPool;
    public static String[] TEMPLATE_NAMES = new String[]{".ml-notifications", ".ml-meta", AnomalyDetectorsIndex.jobStateIndexName(), AnomalyDetectorsIndex.jobResultsIndexPrefix()};
    final AtomicBoolean putMlNotificationsIndexTemplateCheck = new AtomicBoolean(false);
    final AtomicBoolean putMlMetaIndexTemplateCheck = new AtomicBoolean(false);
    final AtomicBoolean putStateIndexTemplateCheck = new AtomicBoolean(false);
    final AtomicBoolean putResultsIndexTemplateCheck = new AtomicBoolean(false);
    private final TimeValue delayedNodeTimeOutSetting;

    public MachineLearningTemplateRegistry(Settings settings, ClusterService clusterService, Client client, ThreadPool threadPool) {
        super(settings);
        this.client = client;
        this.threadPool = threadPool;
        this.delayedNodeTimeOutSetting = (Boolean)MachineLearning.AUTODETECT_PROCESS.get(settings) != false ? (TimeValue)UnassignedInfo.INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING.get(settings) : TimeValue.timeValueNanos((long)0L);
        clusterService.addListener((ClusterStateListener)this);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (event.localNodeMaster() && !event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            this.addTemplatesIfMissing(event.state());
        }
    }

    public void addTemplatesIfMissing(ClusterState state) {
        MetaData metaData = state.metaData();
        this.addMlNotificationsIndexTemplate(metaData);
        this.addMlMetaIndexTemplate(metaData);
        this.addStateIndexTemplate(metaData);
        this.addResultsIndexTemplate(metaData);
    }

    static boolean templateIsPresentAndUpToDate(String templateName, MetaData metaData) {
        IndexTemplateMetaData templateMetaData = (IndexTemplateMetaData)metaData.templates().get((Object)templateName);
        if (templateMetaData == null) {
            return false;
        }
        return templateMetaData.version() != null && templateMetaData.version() >= Version.CURRENT.id;
    }

    private void addMlNotificationsIndexTemplate(MetaData metaData) {
        if (this.putMlNotificationsIndexTemplateCheck.compareAndSet(false, true)) {
            if (!MachineLearningTemplateRegistry.templateIsPresentAndUpToDate(".ml-notifications", metaData)) {
                this.threadPool.executor("generic").execute(() -> this.putNotificationMessageIndexTemplate((result, error) -> {
                    this.putMlNotificationsIndexTemplateCheck.set(false);
                    if (result.booleanValue()) {
                        this.logger.info("successfully created {} index template", (Object)".ml-notifications");
                    } else {
                        this.logger.error((Message)new ParameterizedMessage("not able to create {} index template", (Object)".ml-notifications"), (Throwable)error);
                    }
                }));
            } else {
                this.putMlNotificationsIndexTemplateCheck.set(false);
            }
        }
    }

    private void addMlMetaIndexTemplate(MetaData metaData) {
        if (this.putMlMetaIndexTemplateCheck.compareAndSet(false, true)) {
            if (!MachineLearningTemplateRegistry.templateIsPresentAndUpToDate(".ml-meta", metaData)) {
                this.threadPool.executor("generic").execute(() -> this.putMetaIndexTemplate((result, error) -> {
                    this.putMlMetaIndexTemplateCheck.set(false);
                    if (result.booleanValue()) {
                        this.logger.info("successfully created {} index template", (Object)".ml-meta");
                    } else {
                        this.logger.error((Message)new ParameterizedMessage("not able to create {} index template", (Object)".ml-meta"), (Throwable)error);
                    }
                }));
            } else {
                this.putMlMetaIndexTemplateCheck.set(false);
            }
        }
    }

    private void addStateIndexTemplate(MetaData metaData) {
        String stateIndexName = AnomalyDetectorsIndex.jobStateIndexName();
        if (this.putStateIndexTemplateCheck.compareAndSet(false, true)) {
            if (!MachineLearningTemplateRegistry.templateIsPresentAndUpToDate(stateIndexName, metaData)) {
                this.threadPool.executor("generic").execute(() -> this.putJobStateIndexTemplate((result, error) -> {
                    this.putStateIndexTemplateCheck.set(false);
                    if (result.booleanValue()) {
                        this.logger.info("successfully created {} index template", (Object)stateIndexName);
                    } else {
                        this.logger.error("not able to create " + stateIndexName + " index template", (Throwable)error);
                    }
                }));
            } else {
                this.putStateIndexTemplateCheck.set(false);
            }
        }
    }

    private void addResultsIndexTemplate(MetaData metaData) {
        if (this.putResultsIndexTemplateCheck.compareAndSet(false, true)) {
            if (!MachineLearningTemplateRegistry.templateIsPresentAndUpToDate(AnomalyDetectorsIndex.jobResultsIndexPrefix(), metaData)) {
                this.threadPool.executor("generic").execute(() -> this.putJobResultsIndexTemplate((result, error) -> {
                    this.putResultsIndexTemplateCheck.set(false);
                    if (result.booleanValue()) {
                        this.logger.info("successfully created {} index template", (Object)AnomalyDetectorsIndex.jobResultsIndexPrefix());
                    } else {
                        this.logger.error((Message)new ParameterizedMessage("not able to create {} index template", (Object)AnomalyDetectorsIndex.jobResultsIndexPrefix()), (Throwable)error);
                    }
                }));
            } else {
                this.putResultsIndexTemplateCheck.set(false);
            }
        }
    }

    void putNotificationMessageIndexTemplate(BiConsumer<Boolean, Exception> listener) {
        try (XContentBuilder auditMapping = ElasticsearchMappings.auditMessageMapping();){
            PutIndexTemplateRequest templateRequest = new PutIndexTemplateRequest(".ml-notifications");
            templateRequest.template(".ml-notifications");
            templateRequest.settings(this.mlNotificationIndexSettings());
            templateRequest.mapping(AuditMessage.TYPE.getPreferredName(), auditMapping);
            templateRequest.version(Integer.valueOf(Version.CURRENT.id));
            this.client.admin().indices().putTemplate(templateRequest, ActionListener.wrap(r -> listener.accept(true, null), e -> listener.accept(false, (Exception)e)));
        }
        catch (IOException e2) {
            this.logger.warn("Error putting the template for the notification message index", (Throwable)e2);
            listener.accept(false, (Exception)new ElasticsearchException("Error creating the template mappings for the notification message indices", (Throwable)e2, new Object[0]));
        }
    }

    void putMetaIndexTemplate(BiConsumer<Boolean, Exception> listener) {
        PutIndexTemplateRequest templateRequest = new PutIndexTemplateRequest(".ml-meta");
        templateRequest.template(".ml-meta");
        templateRequest.settings(this.mlNotificationIndexSettings());
        templateRequest.version(Integer.valueOf(Version.CURRENT.id));
        try (XContentBuilder docMapping = MlMetaIndex.docMapping();){
            templateRequest.mapping("doc", docMapping);
        }
        catch (IOException e2) {
            String msg = "Error creating template mappings for the .ml-meta index";
            this.logger.error(msg, (Throwable)e2);
            listener.accept(false, (Exception)new ElasticsearchException(msg, (Throwable)e2, new Object[0]));
        }
        this.client.admin().indices().putTemplate(templateRequest, ActionListener.wrap(r -> listener.accept(true, null), e -> listener.accept(false, (Exception)e)));
    }

    void putJobStateIndexTemplate(BiConsumer<Boolean, Exception> listener) {
        try (XContentBuilder stateMapping = ElasticsearchMappings.stateMapping();){
            PutIndexTemplateRequest templateRequest = new PutIndexTemplateRequest(AnomalyDetectorsIndex.jobStateIndexName());
            templateRequest.template(AnomalyDetectorsIndex.jobStateIndexName());
            templateRequest.settings(this.mlStateIndexSettings());
            templateRequest.mapping("doc", stateMapping);
            templateRequest.version(Integer.valueOf(Version.CURRENT.id));
            this.client.admin().indices().putTemplate(templateRequest, ActionListener.wrap(r -> listener.accept(true, null), e -> listener.accept(false, (Exception)e)));
        }
        catch (IOException e2) {
            this.logger.error("Error creating template mappings for the " + AnomalyDetectorsIndex.jobStateIndexName() + " index", (Throwable)e2);
            listener.accept(false, (Exception)new ElasticsearchException("Error creating template mappings for the " + AnomalyDetectorsIndex.jobStateIndexName() + " indices", (Throwable)e2, new Object[0]));
        }
    }

    void putJobResultsIndexTemplate(BiConsumer<Boolean, Exception> listener) {
        try (XContentBuilder docMapping = ElasticsearchMappings.docMapping();){
            PutIndexTemplateRequest templateRequest = new PutIndexTemplateRequest(AnomalyDetectorsIndex.jobResultsIndexPrefix());
            templateRequest.template(AnomalyDetectorsIndex.jobResultsIndexPrefix() + "*");
            templateRequest.settings(this.mlResultsIndexSettings());
            templateRequest.mapping("doc", docMapping);
            templateRequest.version(Integer.valueOf(Version.CURRENT.id));
            this.client.admin().indices().putTemplate(templateRequest, ActionListener.wrap(r -> listener.accept(true, null), e -> listener.accept(false, (Exception)e)));
        }
        catch (IOException e2) {
            this.logger.error("Error creating template mappings for the " + AnomalyDetectorsIndex.jobResultsIndexPrefix() + " indices", (Throwable)e2);
            listener.accept(false, (Exception)new ElasticsearchException("Error creating template mappings for the " + AnomalyDetectorsIndex.jobResultsIndexPrefix() + " index", (Throwable)e2, new Object[0]));
        }
    }

    Settings.Builder mlResultsIndexSettings() {
        return Settings.builder().put(new Object[]{UnassignedInfo.INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING.getKey(), this.delayedNodeTimeOutSetting}).put(IndexSettings.INDEX_TRANSLOG_DURABILITY_SETTING.getKey(), ASYNC).put(MapperService.INDEX_MAPPER_DYNAMIC_SETTING.getKey(), true).put(IndexSettings.DEFAULT_FIELD_SETTING.getKey(), "all_field_values").put("index.mapping.single_type", true);
    }

    Settings.Builder mlNotificationIndexSettings() {
        return Settings.builder().put("index.number_of_shards", 1).put(new Object[]{UnassignedInfo.INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING.getKey(), this.delayedNodeTimeOutSetting}).put(MapperService.INDEX_MAPPER_DYNAMIC_SETTING.getKey(), true).put("index.mapping.single_type", true);
    }

    Settings.Builder mlStateIndexSettings() {
        return Settings.builder().put(new Object[]{UnassignedInfo.INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING.getKey(), this.delayedNodeTimeOutSetting}).put(IndexSettings.INDEX_TRANSLOG_DURABILITY_SETTING.getKey(), ASYNC).put("index.mapping.single_type", true);
    }

    public static boolean allTemplatesInstalled(MetaData metaData) {
        boolean allPresent = true;
        for (String templateName : TEMPLATE_NAMES) {
            allPresent = allPresent && MachineLearningTemplateRegistry.templateIsPresentAndUpToDate(templateName, metaData);
        }
        return allPresent;
    }
}

