/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.trigger.schedule.support;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.watcher.support.Strings;
import org.elasticsearch.xpack.watcher.trigger.schedule.support.DayOfWeek;
import org.elasticsearch.xpack.watcher.trigger.schedule.support.DayTimes;
import org.elasticsearch.xpack.watcher.trigger.schedule.support.Times;

public class WeekTimes
implements Times {
    public static final EnumSet<DayOfWeek> DEFAULT_DAYS = EnumSet.of(DayOfWeek.MONDAY);
    public static final DayTimes[] DEFAULT_TIMES = new DayTimes[]{new DayTimes()};
    private final EnumSet<DayOfWeek> days;
    private final DayTimes[] times;

    public WeekTimes() {
        this(DEFAULT_DAYS, DEFAULT_TIMES);
    }

    public WeekTimes(DayOfWeek day, DayTimes times) {
        this(day, new DayTimes[]{times});
    }

    public WeekTimes(DayOfWeek day, DayTimes[] times) {
        this(EnumSet.of(day), times);
    }

    public WeekTimes(EnumSet<DayOfWeek> days, DayTimes[] times) {
        this.days = days.isEmpty() ? DEFAULT_DAYS : days;
        this.times = times.length == 0 ? DEFAULT_TIMES : times;
    }

    public EnumSet<DayOfWeek> days() {
        return this.days;
    }

    public DayTimes[] times() {
        return this.times;
    }

    public Set<String> crons() {
        HashSet<String> crons = new HashSet<String>();
        for (DayTimes times : this.times) {
            String hrsStr = Strings.join(",", times.hour);
            String minsStr = Strings.join(",", times.minute);
            String daysStr = DayOfWeek.cronPart(this.days);
            crons.add("0 " + minsStr + " " + hrsStr + " ? * " + daysStr);
        }
        return crons;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WeekTimes that = (WeekTimes)o;
        if (!this.days.equals(that.days)) {
            return false;
        }
        return Sets.newHashSet((Object[])this.times).equals(Sets.newHashSet((Object[])that.times));
    }

    public int hashCode() {
        int result = this.days.hashCode();
        result = 31 * result + Arrays.hashCode(this.times);
        return result;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DAY_FIELD.getPreferredName(), this.days);
        builder.startArray(TIME_FIELD.getPreferredName());
        for (DayTimes dayTimes : this.times) {
            dayTimes.toXContent(builder, params);
        }
        builder.endArray();
        return builder.endObject();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static WeekTimes parse(XContentParser parser, XContentParser.Token token) throws IOException, ElasticsearchParseException {
        DayTimes[] dayTimesArray;
        EnumSet<DayOfWeek> days;
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("could not parse week times. expected an object, but found [{}]", new Object[]{token});
        }
        HashSet<DayOfWeek> daysSet = new HashSet<DayOfWeek>();
        HashSet<DayTimes> timesSet = new HashSet<DayTimes>();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (DAY_FIELD.match(currentFieldName)) {
                if (token.isValue()) {
                    daysSet.add(WeekTimes.parseDayValue(parser, token));
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        daysSet.add(WeekTimes.parseDayValue(parser, token));
                    }
                    continue;
                }
                throw new ElasticsearchParseException("invalid week day value for [{}] field. expected string/number value or an array of string/number values, but found [{}]", new Object[]{currentFieldName, token});
            }
            if (!TIME_FIELD.match(currentFieldName)) continue;
            if (token != XContentParser.Token.START_ARRAY) {
                try {
                    timesSet.add(DayTimes.parse(parser, token));
                    continue;
                }
                catch (ElasticsearchParseException pe) {
                    throw new ElasticsearchParseException("invalid time value for field [{}] - [{}]", (Throwable)pe, new Object[]{currentFieldName, token});
                }
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                try {
                    timesSet.add(DayTimes.parse(parser, token));
                }
                catch (ElasticsearchParseException pe) {
                    throw new ElasticsearchParseException("invalid time value for field [{}] - [{}]", (Throwable)pe, new Object[]{currentFieldName, token});
                }
            }
        }
        EnumSet<DayOfWeek> enumSet = days = daysSet.isEmpty() ? EnumSet.of(DayOfWeek.MONDAY) : EnumSet.copyOf(daysSet);
        if (timesSet.isEmpty()) {
            DayTimes[] dayTimesArray2 = new DayTimes[1];
            dayTimesArray = dayTimesArray2;
            dayTimesArray2[0] = new DayTimes(0, 0);
        } else {
            dayTimesArray = timesSet.toArray(new DayTimes[timesSet.size()]);
        }
        DayTimes[] times = dayTimesArray;
        return new WeekTimes(days, times);
    }

    static DayOfWeek parseDayValue(XContentParser parser, XContentParser.Token token) throws IOException {
        if (token == XContentParser.Token.VALUE_STRING) {
            return DayOfWeek.resolve(parser.text());
        }
        if (token == XContentParser.Token.VALUE_NUMBER) {
            return DayOfWeek.resolve(parser.intValue());
        }
        throw new ElasticsearchParseException("invalid weekly day value. expected a string or a number value, but found [" + token + "]", new Object[0]);
    }

    public static class Builder {
        private final Set<DayOfWeek> days = new HashSet<DayOfWeek>();
        private final Set<DayTimes> times = new HashSet<DayTimes>();

        private Builder() {
        }

        public Builder on(DayOfWeek ... days) {
            Collections.addAll(this.days, days);
            return this;
        }

        public Builder at(int hour, int minute) {
            this.times.add(new DayTimes(hour, minute));
            return this;
        }

        public Builder atRoundHour(int ... hours) {
            this.times.add(new DayTimes(hours, new int[]{0}));
            return this;
        }

        public Builder atNoon() {
            this.times.add(DayTimes.NOON);
            return this;
        }

        public Builder atMidnight() {
            this.times.add(DayTimes.MIDNIGHT);
            return this;
        }

        public WeekTimes build() {
            EnumSet<DayOfWeek> dow = this.days.isEmpty() ? DEFAULT_DAYS : EnumSet.copyOf(this.days);
            return new WeekTimes(dow, this.times.toArray(new DayTimes[this.times.size()]));
        }
    }
}

