/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.input;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.watcher.watch.Payload;

public interface Input
extends ToXContentObject {
    public String type();

    public static interface Field {
        public static final ParseField STATUS = new ParseField("status", new String[0]);
        public static final ParseField TYPE = new ParseField("type", new String[0]);
        public static final ParseField PAYLOAD = new ParseField("payload", new String[0]);
        public static final ParseField REASON = new ParseField("reason", new String[0]);
    }

    public static interface Builder<I extends Input> {
        public I build();
    }

    public static abstract class Result
    implements ToXContentObject {
        protected final String type;
        protected final Status status;
        private final String reason;
        private final Payload payload;

        protected Result(String type, Payload payload) {
            this.status = Status.SUCCESS;
            this.type = type;
            this.payload = payload;
            this.reason = null;
        }

        protected Result(String type, Exception e) {
            this.status = Status.FAILURE;
            this.type = type;
            this.reason = ExceptionsHelper.detailedMessage((Throwable)e);
            this.payload = Payload.EMPTY;
        }

        public String type() {
            return this.type;
        }

        public Status status() {
            return this.status;
        }

        public Payload payload() {
            return this.payload;
        }

        public String reason() {
            assert (this.status == Status.FAILURE);
            return this.reason;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Field.TYPE.getPreferredName(), this.type);
            builder.field(Field.STATUS.getPreferredName(), this.status.name().toLowerCase(Locale.ROOT));
            switch (this.status) {
                case SUCCESS: {
                    assert (this.payload != null);
                    builder.field(Field.PAYLOAD.getPreferredName(), (ToXContent)this.payload, params);
                    break;
                }
                case FAILURE: {
                    assert (this.reason != null);
                    builder.field(Field.REASON.getPreferredName(), this.reason);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            this.typeXContent(builder, params);
            return builder.endObject();
        }

        protected abstract XContentBuilder typeXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

        public static enum Status {
            SUCCESS,
            FAILURE;

        }
    }
}

