/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ssl;

import java.nio.file.Path;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.ssl.CertUtils;
import org.elasticsearch.xpack.ssl.TrustConfig;

class DefaultJDKTrustConfig
extends TrustConfig {
    static final DefaultJDKTrustConfig INSTANCE = new DefaultJDKTrustConfig();

    private DefaultJDKTrustConfig() {
    }

    @Override
    X509ExtendedTrustManager createTrustManager(@Nullable Environment environment) {
        try {
            return CertUtils.trustManager(null, TrustManagerFactory.getDefaultAlgorithm());
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to initialize a TrustManagerFactory", (Throwable)e, new Object[0]);
        }
    }

    @Override
    List<Path> filesToMonitor(@Nullable Environment environment) {
        return Collections.emptyList();
    }

    @Override
    public String toString() {
        return "JDK trusted certs";
    }

    @Override
    public boolean equals(Object o) {
        return o == this;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    static TrustConfig merge(TrustConfig trustConfig) {
        return new CombiningTrustConfig(trustConfig);
    }

    static class CombiningTrustConfig
    extends TrustConfig {
        private final TrustConfig trustConfig;

        private CombiningTrustConfig(TrustConfig trustConfig) {
            this.trustConfig = trustConfig;
        }

        @Override
        X509ExtendedTrustManager createTrustManager(@Nullable Environment environment) {
            X509ExtendedTrustManager trustManager = this.trustConfig.createTrustManager(environment);
            X509ExtendedTrustManager defaultTrustManager = INSTANCE.createTrustManager(environment);
            if (trustManager == null) {
                return defaultTrustManager;
            }
            X509Certificate[] firstIssuers = trustManager.getAcceptedIssuers();
            X509Certificate[] secondIssuers = defaultTrustManager.getAcceptedIssuers();
            Certificate[] acceptedIssuers = new X509Certificate[firstIssuers.length + secondIssuers.length];
            System.arraycopy(firstIssuers, 0, acceptedIssuers, 0, firstIssuers.length);
            System.arraycopy(secondIssuers, 0, acceptedIssuers, firstIssuers.length, secondIssuers.length);
            try {
                return CertUtils.trustManager(acceptedIssuers);
            }
            catch (Exception e) {
                throw new ElasticsearchException("failed to create trust manager", (Throwable)e, new Object[0]);
            }
        }

        @Override
        List<Path> filesToMonitor(@Nullable Environment environment) {
            return this.trustConfig.filesToMonitor(environment);
        }

        @Override
        public String toString() {
            return "Combining Trust Config{first=[" + this.trustConfig.toString() + "], second=[" + INSTANCE.toString() + "]}";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CombiningTrustConfig)) {
                return false;
            }
            CombiningTrustConfig that = (CombiningTrustConfig)o;
            return this.trustConfig.equals(that.trustConfig);
        }

        @Override
        public int hashCode() {
            return this.trustConfig.hashCode();
        }
    }
}

