/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport.netty4;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.net.ssl.SSLEngine;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.netty4.Netty4Transport;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.transport.filter.IPFilter;
import org.elasticsearch.xpack.security.transport.netty4.IpFilterRemoteAddressFilter;
import org.elasticsearch.xpack.ssl.SSLService;

public class SecurityNetty4Transport
extends Netty4Transport {
    private static final Setting<Boolean> PROFILE_SSL_SETTING = Setting.boolSetting((String)Security.setting("ssl.enabled"), (boolean)false, (Setting.Property[])new Setting.Property[0]);
    private final SSLService sslService;
    @Nullable
    private final IPFilter authenticator;
    private final Settings transportSSLSettings;
    private final boolean ssl;

    @Inject
    public SecurityNetty4Transport(Settings settings, ThreadPool threadPool, NetworkService networkService, BigArrays bigArrays, NamedWriteableRegistry namedWriteableRegistry, CircuitBreakerService circuitBreakerService, @Nullable IPFilter authenticator, SSLService sslService) {
        super(settings, threadPool, networkService, bigArrays, namedWriteableRegistry, circuitBreakerService);
        this.authenticator = authenticator;
        this.ssl = (Boolean)XPackSettings.TRANSPORT_SSL_ENABLED.get(settings);
        this.sslService = sslService;
        this.transportSSLSettings = settings.getByPrefix(Security.setting("transport.ssl."));
    }

    protected void doStart() {
        super.doStart();
        if (this.authenticator != null) {
            this.authenticator.setBoundTransportAddress(this.boundAddress(), this.profileBoundAddresses());
        }
    }

    protected ChannelHandler getServerChannelInitializer(String name, Settings settings) {
        return new SecurityServerChannelInitializer(name, settings);
    }

    protected ChannelHandler getClientChannelInitializer() {
        return new SecurityClientChannelInitializer();
    }

    public static boolean isProfileSSLEnabled(Settings profileSettings, boolean defaultTransportSSL) {
        return PROFILE_SSL_SETTING.exists(profileSettings) ? (Boolean)PROFILE_SSL_SETTING.get(profileSettings) : defaultTransportSSL;
    }

    private static class ClientSslHandlerInitializer
    extends ChannelOutboundHandlerAdapter {
        private final boolean hostnameVerificationEnabled;
        private final Settings sslSettings;
        private final SSLService sslService;

        private ClientSslHandlerInitializer(Settings sslSettings, SSLService sslService, boolean hostnameVerificationEnabled) {
            this.sslSettings = sslSettings;
            this.hostnameVerificationEnabled = hostnameVerificationEnabled;
            this.sslService = sslService;
        }

        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            SSLEngine sslEngine;
            if (this.hostnameVerificationEnabled) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)remoteAddress;
                sslEngine = this.sslService.createSSLEngine(this.sslSettings, Settings.EMPTY, inetSocketAddress.getHostString(), inetSocketAddress.getPort());
            } else {
                sslEngine = this.sslService.createSSLEngine(this.sslSettings, Settings.EMPTY);
            }
            sslEngine.setUseClientMode(true);
            ctx.pipeline().replace((ChannelHandler)this, "ssl", (ChannelHandler)new SslHandler(sslEngine));
            super.connect(ctx, remoteAddress, localAddress, promise);
        }
    }

    private class SecurityClientChannelInitializer
    extends Netty4Transport.ClientChannelInitializer {
        private final boolean hostnameVerificationEnabled;

        SecurityClientChannelInitializer() {
            super((Netty4Transport)SecurityNetty4Transport.this);
            this.hostnameVerificationEnabled = SecurityNetty4Transport.this.sslService.getVerificationMode(SecurityNetty4Transport.this.transportSSLSettings, Settings.EMPTY).isHostnameVerificationEnabled();
        }

        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            if (SecurityNetty4Transport.this.ssl) {
                ch.pipeline().addFirst(new ChannelHandler[]{new ClientSslHandlerInitializer(SecurityNetty4Transport.this.transportSSLSettings, SecurityNetty4Transport.this.sslService, this.hostnameVerificationEnabled)});
            }
        }
    }

    class SecurityServerChannelInitializer
    extends Netty4Transport.ServerChannelInitializer {
        private final boolean sslEnabled;
        private final Settings securityProfileSettings;

        SecurityServerChannelInitializer(String name, Settings profileSettings) {
            super((Netty4Transport)SecurityNetty4Transport.this, name, profileSettings);
            this.sslEnabled = SecurityNetty4Transport.isProfileSSLEnabled(profileSettings, SecurityNetty4Transport.this.ssl);
            this.securityProfileSettings = profileSettings.getByPrefix(Security.setting("ssl."));
            if (this.sslEnabled && !SecurityNetty4Transport.this.sslService.isConfigurationValidForServerUsage(this.securityProfileSettings, SecurityNetty4Transport.this.transportSSLSettings)) {
                if ("default".equals(name)) {
                    throw new IllegalArgumentException("a key must be provided to run as a server. the key should be configured using the [xpack.security.transport.ssl.key] or [xpack.security.transport.ssl.keystore.path] setting");
                }
                throw new IllegalArgumentException("a key must be provided to run as a server. the key should be configured using the [transport.profiles." + name + ".xpack.security.ssl.key] or [transport.profiles." + name + ".xpack.security.ssl.keystore.path] setting");
            }
        }

        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            if (this.sslEnabled) {
                SSLEngine serverEngine = SecurityNetty4Transport.this.sslService.createSSLEngine(this.securityProfileSettings, SecurityNetty4Transport.this.transportSSLSettings);
                serverEngine.setUseClientMode(false);
                ch.pipeline().addFirst(new ChannelHandler[]{new SslHandler(serverEngine)});
            }
            if (SecurityNetty4Transport.this.authenticator != null) {
                ch.pipeline().addFirst(new ChannelHandler[]{new IpFilterRemoteAddressFilter(SecurityNetty4Transport.this.authenticator, this.name)});
            }
        }
    }
}

