/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.monitoring.action.MonitoringBulkDoc;
import org.elasticsearch.xpack.monitoring.action.MonitoringIndex;

public class MonitoringBulkRequest
extends ActionRequest {
    final List<MonitoringBulkDoc> docs = new ArrayList<MonitoringBulkDoc>();

    public Collection<MonitoringBulkDoc> getDocs() {
        return Collections.unmodifiableCollection(new ArrayList<MonitoringBulkDoc>(this.docs));
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.docs.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"no monitoring documents added", validationException);
        }
        for (int i = 0; i < this.docs.size(); ++i) {
            MonitoringBulkDoc doc = this.docs.get(i);
            if (!Strings.hasLength((String)doc.getMonitoringId())) {
                validationException = ValidateActions.addValidationError((String)("monitored system id is missing for monitoring document [" + i + "]"), (ActionRequestValidationException)validationException);
            }
            if (!Strings.hasLength((String)doc.getMonitoringVersion())) {
                validationException = ValidateActions.addValidationError((String)("monitored system API version is missing for monitoring document [" + i + "]"), (ActionRequestValidationException)validationException);
            }
            if (!Strings.hasLength((String)doc.getType())) {
                validationException = ValidateActions.addValidationError((String)("type is missing for monitoring document [" + i + "]"), (ActionRequestValidationException)validationException);
            }
            if (doc.getSource() != null && doc.getSource().length() != 0) continue;
            validationException = ValidateActions.addValidationError((String)("source is missing for monitoring document [" + i + "]"), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public MonitoringBulkRequest add(MonitoringBulkDoc doc) {
        this.docs.add(doc);
        return this;
    }

    public MonitoringBulkRequest add(BytesReference content, String defaultMonitoringId, String defaultMonitoringApiVersion, String defaultType, XContentType xContentType) throws IOException {
        BulkRequest bulkRequest = Requests.bulkRequest().add(content, null, defaultType, xContentType);
        for (DocWriteRequest request : bulkRequest.requests()) {
            if (request instanceof IndexRequest) {
                IndexRequest indexRequest = (IndexRequest)request;
                MonitoringBulkDoc doc = new MonitoringBulkDoc(defaultMonitoringId, defaultMonitoringApiVersion, MonitoringIndex.from(indexRequest.index()), indexRequest.type(), indexRequest.id(), indexRequest.source(), xContentType);
                this.add(doc);
                continue;
            }
            throw new IllegalArgumentException("monitoring bulk requests should only contain index requests");
        }
        return this;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.docs.addAll(in.readList(MonitoringBulkDoc::readFrom));
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeList(this.docs);
    }
}

