/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.notifications;

import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.xpack.ml.notifications.AuditMessage;

public class Auditor {
    public static final String NOTIFICATIONS_INDEX = ".ml-notifications";
    private static final Logger LOGGER = Loggers.getLogger(Auditor.class);
    private final Client client;
    private final ClusterService clusterService;

    public Auditor(Client client, ClusterService clusterService) {
        this.client = Objects.requireNonNull(client);
        this.clusterService = clusterService;
    }

    public void info(String jobId, String message) {
        this.indexDoc(AuditMessage.TYPE.getPreferredName(), (ToXContent)AuditMessage.newInfo(jobId, message, this.clusterService.localNode().getName()));
    }

    public void warning(String jobId, String message) {
        this.indexDoc(AuditMessage.TYPE.getPreferredName(), (ToXContent)AuditMessage.newWarning(jobId, message, this.clusterService.localNode().getName()));
    }

    public void error(String jobId, String message) {
        this.indexDoc(AuditMessage.TYPE.getPreferredName(), (ToXContent)AuditMessage.newError(jobId, message, this.clusterService.localNode().getName()));
    }

    private void indexDoc(final String type, ToXContent toXContent) {
        IndexRequest indexRequest = new IndexRequest(NOTIFICATIONS_INDEX, type);
        indexRequest.source(this.toXContentBuilder(toXContent));
        indexRequest.timeout(TimeValue.timeValueSeconds((long)5L));
        this.client.index(indexRequest, (ActionListener)new ActionListener<IndexResponse>(){

            public void onResponse(IndexResponse indexResponse) {
                LOGGER.trace("Successfully persisted {}", (Object)type);
            }

            public void onFailure(Exception e) {
                LOGGER.debug((Message)new ParameterizedMessage("Error writing {}", new Object[]{type}, (Throwable)e));
            }
        });
    }

    private XContentBuilder toXContentBuilder(ToXContent toXContent) {
        try {
            return toXContent.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

