/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.normalizer;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.ml.job.process.normalizer.AbstractLeafNormalizable;
import org.elasticsearch.xpack.ml.job.process.normalizer.Level;
import org.elasticsearch.xpack.ml.job.results.PartitionScore;

public class PartitionScoreNormalizable
extends AbstractLeafNormalizable {
    private final PartitionScore score;

    public PartitionScoreNormalizable(PartitionScore score, String indexName) {
        super(indexName);
        this.score = Objects.requireNonNull(score);
    }

    @Override
    public String getId() {
        throw new IllegalStateException("PartitionScore has no ID as is should not be persisted outside of the owning bucket");
    }

    @Override
    public Level getLevel() {
        return Level.PARTITION;
    }

    @Override
    public String getPartitionFieldName() {
        return this.score.getPartitionFieldName();
    }

    @Override
    public String getPartitionFieldValue() {
        return this.score.getPartitionFieldValue();
    }

    @Override
    public String getPersonFieldName() {
        return null;
    }

    @Override
    public String getFunctionName() {
        return null;
    }

    @Override
    public String getValueFieldName() {
        return null;
    }

    @Override
    public double getProbability() {
        return this.score.getProbability();
    }

    @Override
    public double getNormalizedScore() {
        return this.score.getRecordScore();
    }

    @Override
    public void setNormalizedScore(double normalizedScore) {
        this.score.setRecordScore(normalizedScore);
    }

    @Override
    public void setParentScore(double parentScore) {
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.score.toXContent(builder, params);
    }
}

