/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process;

import java.util.Date;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.Counter;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.xpack.ml.job.config.Job;

public class DataStreamDiagnostics {
    private static final int MIN_BUCKET_WINDOW = 10;
    private static final int DATA_SPARSITY_THRESHOLD = 2;
    private static final long MS_IN_SECOND = 1000L;
    private static final Logger LOGGER = Loggers.getLogger(DataStreamDiagnostics.class);
    private final SortedMap<Long, Counter> movingBucketHistogram = new TreeMap<Long, Counter>();
    private final long bucketSpan;
    private final long latency;
    private long movingBucketCount = 0L;
    private long latestReportedBucket = -1L;
    private long bucketCount = 0L;
    private long emptyBucketCount = 0L;
    private long latestEmptyBucketTime = -1L;
    private long sparseBucketCount = 0L;
    private long latestSparseBucketTime = -1L;

    public DataStreamDiagnostics(Job job) {
        this.bucketSpan = job.getAnalysisConfig().getBucketSpan().seconds();
        this.latency = job.getAnalysisConfig().getLatency() == null ? 0L : job.getAnalysisConfig().getLatency().seconds();
    }

    public void checkRecord(long recordTimestampInMs) {
        this.checkBucketing(recordTimestampInMs);
    }

    public void flush() {
        if (!this.movingBucketHistogram.isEmpty()) {
            this.flush(this.movingBucketHistogram.lastKey() + 1L);
        }
    }

    private void checkBucketing(long recordTimestampInMs) {
        long bucket = recordTimestampInMs / 1000L / this.bucketSpan;
        long bucketHistogramStartBucket = (recordTimestampInMs / 1000L - this.latency) / this.bucketSpan;
        bucketHistogramStartBucket = Math.min(bucket - 10L, bucketHistogramStartBucket);
        this.movingBucketHistogram.computeIfAbsent(bucket, l -> Counter.newCounter()).addAndGet(1L);
        ++this.movingBucketCount;
        if (this.latestReportedBucket == -1L) {
            this.latestReportedBucket = bucket - 1L;
        }
        this.flush(bucketHistogramStartBucket);
    }

    private void flush(long bucketNumber) {
        long bucketSize;
        Counter bucketSizeHolder;
        long pruneBucket;
        long emptyBuckets = this.movingBucketHistogram.firstKey() - this.latestReportedBucket - 1L;
        if (emptyBuckets > 0L) {
            this.bucketCount += emptyBuckets;
            this.emptyBucketCount += emptyBuckets;
            this.latestEmptyBucketTime = (this.movingBucketHistogram.firstKey() - 1L) * this.bucketSpan * 1000L;
            this.latestReportedBucket = this.movingBucketHistogram.firstKey() - 1L;
        }
        double averageBucketSize = (float)this.movingBucketCount / (float)this.movingBucketHistogram.size();
        long lastBucketSparsityCheck = Math.min(bucketNumber, this.movingBucketHistogram.lastKey());
        for (pruneBucket = this.movingBucketHistogram.firstKey().longValue(); pruneBucket < lastBucketSparsityCheck; ++pruneBucket) {
            double logBucketSize;
            bucketSizeHolder = (Counter)this.movingBucketHistogram.remove(pruneBucket);
            bucketSize = bucketSizeHolder != null ? bucketSizeHolder.get() : 0L;
            LOGGER.debug("Checking bucket {} compare sizes, this bucket: {} average: {}", (Object)pruneBucket, (Object)bucketSize, (Object)averageBucketSize);
            ++this.bucketCount;
            this.latestReportedBucket = pruneBucket;
            this.movingBucketCount -= bucketSize;
            if (bucketSize == 0L) {
                this.latestEmptyBucketTime = pruneBucket * this.bucketSpan * 1000L;
                ++this.emptyBucketCount;
                continue;
            }
            double logAverageBucketSize = Math.log(averageBucketSize);
            double sparsityScore = logAverageBucketSize - (logBucketSize = Math.log(bucketSize));
            if (!(sparsityScore > 2.0)) continue;
            LOGGER.debug("Sparse bucket {}, this bucket: {} average: {}, sparsity score: {}", (Object)pruneBucket, (Object)bucketSize, (Object)averageBucketSize, (Object)sparsityScore);
            ++this.sparseBucketCount;
            this.latestSparseBucketTime = pruneBucket * this.bucketSpan * 1000L;
        }
        for (pruneBucket = lastBucketSparsityCheck; pruneBucket < bucketNumber; ++pruneBucket) {
            bucketSizeHolder = (Counter)this.movingBucketHistogram.remove(pruneBucket);
            bucketSize = bucketSizeHolder != null ? bucketSizeHolder.get() : 0L;
            ++this.bucketCount;
            this.latestReportedBucket = pruneBucket;
            this.movingBucketCount -= bucketSize;
            if (bucketSize != 0L) continue;
            this.latestEmptyBucketTime = pruneBucket * this.bucketSpan * 1000L;
            ++this.emptyBucketCount;
        }
    }

    public long getBucketCount() {
        return this.bucketCount;
    }

    public long getEmptyBucketCount() {
        return this.emptyBucketCount;
    }

    public Date getLatestEmptyBucketTime() {
        return this.latestEmptyBucketTime > 0L ? new Date(this.latestEmptyBucketTime) : null;
    }

    public long getSparseBucketCount() {
        return this.sparseBucketCount;
    }

    public Date getLatestSparseBucketTime() {
        return this.latestSparseBucketTime > 0L ? new Date(this.latestSparseBucketTime) : null;
    }

    public void resetCounts() {
        this.bucketCount = 0L;
        this.emptyBucketCount = 0L;
        this.sparseBucketCount = 0L;
    }
}

