/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.xpack.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.ml.job.persistence.JobDataDeleter;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.Quantiles;
import org.elasticsearch.xpack.ml.job.results.AnomalyRecord;
import org.elasticsearch.xpack.ml.job.results.Bucket;
import org.elasticsearch.xpack.ml.job.results.BucketInfluencer;
import org.elasticsearch.xpack.ml.job.results.CategoryDefinition;
import org.elasticsearch.xpack.ml.job.results.Influencer;
import org.elasticsearch.xpack.ml.job.results.ModelPlot;
import org.elasticsearch.xpack.ml.job.results.PerPartitionMaxProbabilities;
import org.elasticsearch.xpack.ml.job.results.Result;

public class JobResultsPersister
extends AbstractComponent {
    private final Client client;

    public JobResultsPersister(Settings settings, Client client) {
        super(settings);
        this.client = client;
    }

    public Builder bulkPersisterBuilder(String jobId) {
        return new Builder(jobId);
    }

    public void persistCategoryDefinition(CategoryDefinition category) {
        Persistable persistable = new Persistable(category.getJobId(), (ToXContent)category, CategoryDefinition.TYPE.getPreferredName(), CategoryDefinition.documentId(category.getJobId(), Long.toString(category.getCategoryId())));
        persistable.persist(AnomalyDetectorsIndex.jobResultsAliasedName(category.getJobId()));
    }

    public void persistQuantiles(Quantiles quantiles) {
        Persistable persistable = new Persistable(quantiles.getJobId(), (ToXContent)quantiles, Quantiles.TYPE.getPreferredName(), Quantiles.documentId(quantiles.getJobId()));
        persistable.persist(AnomalyDetectorsIndex.jobStateIndexName());
    }

    public void persistModelSnapshot(ModelSnapshot modelSnapshot) {
        Persistable persistable = new Persistable(modelSnapshot.getJobId(), (ToXContent)modelSnapshot, ModelSnapshot.TYPE.getPreferredName(), ModelSnapshot.documentId(modelSnapshot));
        persistable.persist(AnomalyDetectorsIndex.jobResultsAliasedName(modelSnapshot.getJobId()));
    }

    public void persistModelSizeStats(ModelSizeStats modelSizeStats) {
        String jobId = modelSizeStats.getJobId();
        this.logger.trace("[{}] Persisting model size stats, for size {}", (Object)jobId, (Object)modelSizeStats.getModelBytes());
        Persistable persistable = new Persistable(modelSizeStats.getJobId(), (ToXContent)modelSizeStats, Result.TYPE.getPreferredName(), ModelSizeStats.documentId(jobId));
        persistable.persist(AnomalyDetectorsIndex.jobResultsAliasedName(jobId));
        persistable = new Persistable(modelSizeStats.getJobId(), (ToXContent)modelSizeStats, Result.TYPE.getPreferredName(), null);
        persistable.persist(AnomalyDetectorsIndex.jobResultsAliasedName(jobId));
    }

    public void persistModelPlot(ModelPlot modelPlot) {
        Persistable persistable = new Persistable(modelPlot.getJobId(), (ToXContent)modelPlot, Result.TYPE.getPreferredName(), null);
        persistable.persist(AnomalyDetectorsIndex.jobResultsAliasedName(modelPlot.getJobId()));
    }

    public void deleteInterimResults(String jobId) {
        JobDataDeleter deleter = new JobDataDeleter(this.client, jobId, true);
        deleter.deleteInterimResults();
        deleter.commit(false);
    }

    public boolean commitResultWrites(String jobId) {
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName(jobId);
        this.logger.trace("[{}] ES API CALL: refresh index {}", (Object)jobId, (Object)indexName);
        RefreshRequest refreshRequest = new RefreshRequest(new String[]{indexName});
        refreshRequest.indicesOptions(IndicesOptions.lenientExpandOpen());
        this.client.admin().indices().refresh(refreshRequest).actionGet();
        return true;
    }

    public boolean commitStateWrites(String jobId) {
        String indexName = AnomalyDetectorsIndex.jobStateIndexName();
        this.logger.trace("[{}] ES API CALL: refresh index {}", (Object)jobId, (Object)indexName);
        RefreshRequest refreshRequest = new RefreshRequest(new String[]{indexName});
        refreshRequest.indicesOptions(IndicesOptions.lenientExpandOpen());
        this.client.admin().indices().refresh(refreshRequest).actionGet();
        return true;
    }

    XContentBuilder toXContentBuilder(ToXContent obj) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        obj.toXContent(builder, ToXContent.EMPTY_PARAMS);
        return builder;
    }

    private XContentBuilder serialiseBucketInfluencerStandalone(BucketInfluencer bucketInfluencer) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        bucketInfluencer.toXContent(builder, ToXContent.EMPTY_PARAMS);
        return builder;
    }

    private class Persistable {
        private final String jobId;
        private final ToXContent object;
        private final String type;
        private final String id;

        Persistable(String jobId, ToXContent object, String type, String id) {
            this.jobId = jobId;
            this.object = object;
            this.type = type;
            this.id = id;
        }

        boolean persist(String indexName) {
            if (this.object == null) {
                JobResultsPersister.this.logger.warn("[{}] No {} to persist for job ", (Object)this.jobId, (Object)this.type);
                return false;
            }
            this.logCall(indexName);
            try {
                IndexRequest indexRequest = new IndexRequest(indexName, this.type, this.id).source(JobResultsPersister.this.toXContentBuilder(this.object));
                JobResultsPersister.this.client.index(indexRequest).actionGet();
                return true;
            }
            catch (IOException e) {
                JobResultsPersister.this.logger.error((Message)new ParameterizedMessage("[{}] Error writing {}", new Object[]{this.jobId, this.type}), (Throwable)e);
                return false;
            }
        }

        private void logCall(String indexName) {
            if (this.id != null) {
                JobResultsPersister.this.logger.trace("[{}] ES API CALL: index type {} to index {} with ID {}", (Object)this.jobId, (Object)this.type, (Object)indexName, (Object)this.id);
            } else {
                JobResultsPersister.this.logger.trace("[{}] ES API CALL: index type {} to index {} with auto-generated ID", (Object)this.jobId, (Object)this.type, (Object)indexName);
            }
        }
    }

    public class Builder {
        private BulkRequest bulkRequest;
        private final String jobId;
        private final String indexName;

        private Builder(String jobId) {
            this.jobId = Objects.requireNonNull(jobId);
            this.indexName = AnomalyDetectorsIndex.jobResultsAliasedName(jobId);
            this.bulkRequest = new BulkRequest();
        }

        public Builder persistBucket(Bucket bucket) {
            Bucket bucketWithoutRecords = bucket;
            if (!bucketWithoutRecords.getRecords().isEmpty()) {
                bucketWithoutRecords = new Bucket(bucket);
                bucketWithoutRecords.setRecords(Collections.emptyList());
            }
            try {
                XContentBuilder content = JobResultsPersister.this.toXContentBuilder((ToXContent)bucketWithoutRecords);
                JobResultsPersister.this.logger.trace("[{}] ES API CALL: index result type {} to index {} at epoch {}", (Object)this.jobId, (Object)"bucket", (Object)this.indexName, (Object)bucketWithoutRecords.getEpoch());
                this.bulkRequest.add(new IndexRequest(this.indexName, Result.TYPE.getPreferredName(), bucketWithoutRecords.getId()).source(content));
                this.persistBucketInfluencersStandalone(this.jobId, bucketWithoutRecords.getBucketInfluencers());
            }
            catch (IOException e) {
                JobResultsPersister.this.logger.error((Message)new ParameterizedMessage("[{}] Error serialising bucket", new Object[]{this.jobId}), (Throwable)e);
            }
            return this;
        }

        private void persistBucketInfluencersStandalone(String jobId, List<BucketInfluencer> bucketInfluencers) throws IOException {
            if (bucketInfluencers != null && !bucketInfluencers.isEmpty()) {
                for (BucketInfluencer bucketInfluencer : bucketInfluencers) {
                    XContentBuilder content = JobResultsPersister.this.serialiseBucketInfluencerStandalone(bucketInfluencer);
                    String id = bucketInfluencer.getId();
                    JobResultsPersister.this.logger.trace("[{}] ES BULK ACTION: index result type {} to index {} with ID {}", (Object)jobId, (Object)"bucket_influencer", (Object)this.indexName, (Object)id);
                    this.bulkRequest.add(new IndexRequest(this.indexName, Result.TYPE.getPreferredName(), id).source(content));
                }
            }
        }

        public Builder persistRecords(List<AnomalyRecord> records) {
            try {
                for (AnomalyRecord record : records) {
                    XContentBuilder content = JobResultsPersister.this.toXContentBuilder((ToXContent)record);
                    JobResultsPersister.this.logger.trace("[{}] ES BULK ACTION: index result type {} to index {} with ID {}", (Object)this.jobId, (Object)"record", (Object)this.indexName, (Object)record.getId());
                    this.bulkRequest.add(new IndexRequest(this.indexName, Result.TYPE.getPreferredName(), record.getId()).source(content));
                }
            }
            catch (IOException e) {
                JobResultsPersister.this.logger.error((Message)new ParameterizedMessage("[{}] Error serialising records", new Object[]{this.jobId}), (Throwable)e);
            }
            return this;
        }

        public Builder persistInfluencers(List<Influencer> influencers) {
            try {
                for (Influencer influencer : influencers) {
                    XContentBuilder content = JobResultsPersister.this.toXContentBuilder((ToXContent)influencer);
                    JobResultsPersister.this.logger.trace("[{}] ES BULK ACTION: index result type {} to index {} with ID {}", (Object)this.jobId, (Object)"influencer", (Object)this.indexName, (Object)influencer.getId());
                    this.bulkRequest.add(new IndexRequest(this.indexName, Result.TYPE.getPreferredName(), influencer.getId()).source(content));
                }
            }
            catch (IOException e) {
                JobResultsPersister.this.logger.error((Message)new ParameterizedMessage("[{}] Error serialising influencers", new Object[]{this.jobId}), (Throwable)e);
            }
            return this;
        }

        public Builder persistPerPartitionMaxProbabilities(PerPartitionMaxProbabilities partitionProbabilities) {
            try {
                XContentBuilder builder = JobResultsPersister.this.toXContentBuilder((ToXContent)partitionProbabilities);
                JobResultsPersister.this.logger.trace("[{}] ES API CALL: index result type {} to index {} at timestamp {} with ID {}", (Object)this.jobId, (Object)"partition_normalized_probs", (Object)this.indexName, (Object)partitionProbabilities.getTimestamp(), (Object)partitionProbabilities.getId());
                this.bulkRequest.add(new IndexRequest(this.indexName, Result.TYPE.getPreferredName(), partitionProbabilities.getId()).source(builder));
            }
            catch (IOException e) {
                JobResultsPersister.this.logger.error((Message)new ParameterizedMessage("[{}] error serialising bucket per partition max normalized scores", new Object[]{this.jobId}), (Throwable)e);
            }
            return this;
        }

        public void executeRequest() {
            if (this.bulkRequest.numberOfActions() == 0) {
                return;
            }
            JobResultsPersister.this.logger.trace("[{}] ES API CALL: bulk request with {} actions", (Object)this.jobId, (Object)this.bulkRequest.numberOfActions());
            BulkResponse addRecordsResponse = (BulkResponse)JobResultsPersister.this.client.bulk(this.bulkRequest).actionGet();
            if (addRecordsResponse.hasFailures()) {
                JobResultsPersister.this.logger.error("[{}] Bulk index of results has errors: {}", (Object)this.jobId, (Object)addRecordsResponse.buildFailureMessage());
            }
            this.bulkRequest = new BulkRequest();
        }

        BulkRequest getBulkRequest() {
            return this.bulkRequest;
        }
    }
}

