/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.io.IOException;
import java.util.Collection;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelState;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.Quantiles;
import org.elasticsearch.xpack.ml.job.results.AnomalyCause;
import org.elasticsearch.xpack.ml.job.results.AnomalyRecord;
import org.elasticsearch.xpack.ml.job.results.Bucket;
import org.elasticsearch.xpack.ml.job.results.BucketInfluencer;
import org.elasticsearch.xpack.ml.job.results.CategoryDefinition;
import org.elasticsearch.xpack.ml.job.results.Influence;
import org.elasticsearch.xpack.ml.job.results.Influencer;
import org.elasticsearch.xpack.ml.job.results.ModelPlot;
import org.elasticsearch.xpack.ml.job.results.PerPartitionMaxProbabilities;
import org.elasticsearch.xpack.ml.job.results.ReservedFieldNames;
import org.elasticsearch.xpack.ml.job.results.Result;
import org.elasticsearch.xpack.ml.notifications.AuditMessage;

public class ElasticsearchMappings {
    static final String ENABLED = "enabled";
    static final String ANALYZER = "analyzer";
    static final String WHITESPACE = "whitespace";
    static final String NESTED = "nested";
    static final String COPY_TO = "copy_to";
    static final String PROPERTIES = "properties";
    static final String TYPE = "type";
    static final String DYNAMIC = "dynamic";
    static final String FIELDS = "fields";
    public static final String ALL_FIELD_VALUES = "all_field_values";
    static final String ES_DOC = "_doc";
    static final String BOOLEAN = "boolean";
    static final String DATE = "date";
    static final String DOUBLE = "double";
    static final String INTEGER = "integer";
    static final String KEYWORD = "keyword";
    static final String LONG = "long";
    static final String TEXT = "text";
    static final String RAW = "raw";

    private ElasticsearchMappings() {
    }

    public static XContentBuilder resultsMapping() throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject(Result.TYPE.getPreferredName()).startObject(PROPERTIES).startObject(ALL_FIELD_VALUES).field(TYPE, TEXT).field(ANALYZER, WHITESPACE).endObject().startObject(Result.RESULT_TYPE.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(Job.ID.getPreferredName()).field(TYPE, KEYWORD).field(COPY_TO, ALL_FIELD_VALUES).endObject().startObject(Result.TIMESTAMP.getPreferredName()).field(TYPE, DATE).endObject().startObject(Bucket.ANOMALY_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(BucketInfluencer.RAW_ANOMALY_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(Bucket.INITIAL_ANOMALY_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(Bucket.IS_INTERIM.getPreferredName()).field(TYPE, BOOLEAN).endObject().startObject(Bucket.RECORD_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(Bucket.EVENT_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(Bucket.BUCKET_SPAN.getPreferredName()).field(TYPE, LONG).endObject().startObject(Bucket.PROCESSING_TIME_MS.getPreferredName()).field(TYPE, LONG).endObject().startObject(Bucket.PARTITION_SCORES.getPreferredName()).field(TYPE, NESTED).startObject(PROPERTIES).startObject(AnomalyRecord.PARTITION_FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyRecord.PARTITION_FIELD_VALUE.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(Bucket.INITIAL_ANOMALY_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(AnomalyRecord.PROBABILITY.getPreferredName()).field(TYPE, DOUBLE).endObject().endObject().endObject().startObject(Bucket.BUCKET_INFLUENCERS.getPreferredName()).field(TYPE, NESTED).startObject(PROPERTIES).startObject(Job.ID.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(Result.RESULT_TYPE.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(BucketInfluencer.INFLUENCER_FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(BucketInfluencer.INITIAL_ANOMALY_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(BucketInfluencer.ANOMALY_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(BucketInfluencer.RAW_ANOMALY_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(BucketInfluencer.PROBABILITY.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(Result.TIMESTAMP.getPreferredName()).field(TYPE, DATE).endObject().startObject(BucketInfluencer.BUCKET_SPAN.getPreferredName()).field(TYPE, LONG).endObject().startObject(BucketInfluencer.SEQUENCE_NUM.getPreferredName()).field(TYPE, INTEGER).endObject().startObject(BucketInfluencer.IS_INTERIM.getPreferredName()).field(TYPE, BOOLEAN).endObject().endObject().endObject().startObject(PerPartitionMaxProbabilities.PER_PARTITION_MAX_PROBABILITIES.getPreferredName()).field(TYPE, NESTED).startObject(PROPERTIES).startObject(AnomalyRecord.PARTITION_FIELD_VALUE.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(PerPartitionMaxProbabilities.MAX_RECORD_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().endObject().endObject().startObject(ModelPlot.MODEL_FEATURE.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(ModelPlot.MODEL_LOWER.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(ModelPlot.MODEL_UPPER.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(ModelPlot.MODEL_MEDIAN.getPreferredName()).field(TYPE, DOUBLE).endObject();
        ElasticsearchMappings.addAnomalyRecordFieldsToMapping(builder);
        ElasticsearchMappings.addInfluencerFieldsToMapping(builder);
        ElasticsearchMappings.addModelSizeStatsFieldsToMapping(builder);
        builder.endObject();
        builder.endObject();
        builder.endObject();
        return builder;
    }

    static XContentBuilder termFieldsMapping(String type, Collection<String> termFields) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
            if (type != null) {
                builder.startObject(type);
            }
            builder.startObject(PROPERTIES);
            ElasticsearchMappings.addTermFields(builder, termFields);
            builder.endObject();
            if (type != null) {
                builder.endObject();
            }
            return builder.endObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void addTermFields(XContentBuilder builder, Collection<String> termFields) throws IOException {
        for (String fieldName : termFields) {
            if (!ReservedFieldNames.isValidFieldName(fieldName)) continue;
            builder.startObject(fieldName).field(TYPE, KEYWORD).endObject();
        }
    }

    private static XContentBuilder addAnomalyRecordFieldsToMapping(XContentBuilder builder) throws IOException {
        builder.startObject(AnomalyRecord.DETECTOR_INDEX.getPreferredName()).field(TYPE, INTEGER).endObject().startObject(AnomalyRecord.SEQUENCE_NUM.getPreferredName()).field(TYPE, INTEGER).endObject().startObject(AnomalyRecord.ACTUAL.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(AnomalyRecord.TYPICAL.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(AnomalyRecord.PROBABILITY.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(AnomalyRecord.FUNCTION.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyRecord.FUNCTION_DESCRIPTION.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyRecord.BY_FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyRecord.BY_FIELD_VALUE.getPreferredName()).field(TYPE, KEYWORD).field(COPY_TO, ALL_FIELD_VALUES).endObject().startObject(AnomalyRecord.FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyRecord.PARTITION_FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyRecord.PARTITION_FIELD_VALUE.getPreferredName()).field(TYPE, KEYWORD).field(COPY_TO, ALL_FIELD_VALUES).endObject().startObject(AnomalyRecord.OVER_FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyRecord.OVER_FIELD_VALUE.getPreferredName()).field(TYPE, KEYWORD).field(COPY_TO, ALL_FIELD_VALUES).endObject().startObject(AnomalyRecord.RECORD_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(AnomalyRecord.INITIAL_RECORD_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(AnomalyRecord.CAUSES.getPreferredName()).field(TYPE, NESTED).startObject(PROPERTIES).startObject(AnomalyCause.ACTUAL.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(AnomalyCause.TYPICAL.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(AnomalyCause.PROBABILITY.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(AnomalyCause.FUNCTION.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyCause.FUNCTION_DESCRIPTION.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyCause.BY_FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyCause.BY_FIELD_VALUE.getPreferredName()).field(TYPE, KEYWORD).field(COPY_TO, ALL_FIELD_VALUES).endObject().startObject(AnomalyCause.CORRELATED_BY_FIELD_VALUE.getPreferredName()).field(TYPE, KEYWORD).field(COPY_TO, ALL_FIELD_VALUES).endObject().startObject(AnomalyCause.FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyCause.PARTITION_FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyCause.PARTITION_FIELD_VALUE.getPreferredName()).field(TYPE, KEYWORD).field(COPY_TO, ALL_FIELD_VALUES).endObject().startObject(AnomalyCause.OVER_FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyCause.OVER_FIELD_VALUE.getPreferredName()).field(TYPE, KEYWORD).field(COPY_TO, ALL_FIELD_VALUES).endObject().endObject().endObject().startObject(AnomalyRecord.INFLUENCERS.getPreferredName()).field(TYPE, NESTED).startObject(PROPERTIES).startObject(Influence.INFLUENCER_FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(Influence.INFLUENCER_FIELD_VALUES.getPreferredName()).field(TYPE, KEYWORD).field(COPY_TO, ALL_FIELD_VALUES).endObject().endObject().endObject();
        return builder;
    }

    private static XContentBuilder addInfluencerFieldsToMapping(XContentBuilder builder) throws IOException {
        builder.startObject(Influencer.INFLUENCER_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(Influencer.INITIAL_INFLUENCER_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(Influencer.INFLUENCER_FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(Influencer.INFLUENCER_FIELD_VALUE.getPreferredName()).field(TYPE, KEYWORD).field(COPY_TO, ALL_FIELD_VALUES).endObject();
        return builder;
    }

    public static XContentBuilder dataCountsMapping() throws IOException {
        return XContentFactory.jsonBuilder().startObject().startObject(DataCounts.TYPE.getPreferredName()).startObject(PROPERTIES).startObject(Job.ID.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(DataCounts.PROCESSED_RECORD_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.PROCESSED_FIELD_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.INPUT_BYTES.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.INPUT_RECORD_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.INPUT_FIELD_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.INVALID_DATE_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.MISSING_FIELD_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.OUT_OF_ORDER_TIME_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.EMPTY_BUCKET_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.SPARSE_BUCKET_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.BUCKET_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.EARLIEST_RECORD_TIME.getPreferredName()).field(TYPE, DATE).endObject().startObject(DataCounts.LATEST_RECORD_TIME.getPreferredName()).field(TYPE, DATE).endObject().startObject(DataCounts.LATEST_EMPTY_BUCKET_TIME.getPreferredName()).field(TYPE, DATE).endObject().startObject(DataCounts.LATEST_SPARSE_BUCKET_TIME.getPreferredName()).field(TYPE, DATE).endObject().startObject(DataCounts.LAST_DATA_TIME.getPreferredName()).field(TYPE, DATE).endObject().endObject().endObject().endObject();
    }

    public static XContentBuilder categorizerStateMapping() throws IOException {
        return XContentFactory.jsonBuilder().startObject().startObject("categorizer_state").field(ENABLED, false).endObject().endObject();
    }

    public static XContentBuilder quantilesMapping() throws IOException {
        return XContentFactory.jsonBuilder().startObject().startObject(Quantiles.TYPE.getPreferredName()).field(ENABLED, false).endObject().endObject();
    }

    public static XContentBuilder categoryDefinitionMapping() throws IOException {
        return XContentFactory.jsonBuilder().startObject().startObject(CategoryDefinition.TYPE.getPreferredName()).startObject(PROPERTIES).startObject(CategoryDefinition.CATEGORY_ID.getPreferredName()).field(TYPE, LONG).endObject().startObject(Job.ID.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(CategoryDefinition.TERMS.getPreferredName()).field(TYPE, TEXT).endObject().startObject(CategoryDefinition.REGEX.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(CategoryDefinition.MAX_MATCHING_LENGTH.getPreferredName()).field(TYPE, LONG).endObject().startObject(CategoryDefinition.EXAMPLES.getPreferredName()).field(TYPE, TEXT).endObject().endObject().endObject().endObject();
    }

    public static XContentBuilder modelStateMapping() throws IOException {
        return XContentFactory.jsonBuilder().startObject().startObject(ModelState.TYPE.getPreferredName()).field(ENABLED, false).endObject().endObject();
    }

    public static XContentBuilder modelSnapshotMapping() throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject(ModelSnapshot.TYPE.getPreferredName()).startObject(PROPERTIES).startObject(Job.ID.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(ModelSnapshot.TIMESTAMP.getPreferredName()).field(TYPE, DATE).endObject().startObject(ModelSnapshot.DESCRIPTION.getPreferredName()).field(TYPE, TEXT).endObject().startObject(ModelSnapshot.SNAPSHOT_ID.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(ModelSnapshot.SNAPSHOT_DOC_COUNT.getPreferredName()).field(TYPE, INTEGER).endObject().startObject(ModelSnapshot.RETAIN.getPreferredName()).field(TYPE, BOOLEAN).endObject().startObject(ModelSizeStats.RESULT_TYPE_FIELD.getPreferredName()).startObject(PROPERTIES).startObject(Job.ID.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(Result.RESULT_TYPE.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(ModelSizeStats.TIMESTAMP_FIELD.getPreferredName()).field(TYPE, DATE).endObject();
        ElasticsearchMappings.addModelSizeStatsFieldsToMapping(builder);
        builder.endObject().endObject().startObject(Quantiles.TYPE.getPreferredName()).field(ENABLED, false).endObject().startObject(ModelSnapshot.LATEST_RECORD_TIME.getPreferredName()).field(TYPE, DATE).endObject().startObject(ModelSnapshot.LATEST_RESULT_TIME.getPreferredName()).field(TYPE, DATE).endObject().endObject().endObject().endObject();
        return builder;
    }

    private static XContentBuilder addModelSizeStatsFieldsToMapping(XContentBuilder builder) throws IOException {
        builder.startObject(ModelSizeStats.MODEL_BYTES_FIELD.getPreferredName()).field(TYPE, LONG).endObject().startObject(ModelSizeStats.TOTAL_BY_FIELD_COUNT_FIELD.getPreferredName()).field(TYPE, LONG).endObject().startObject(ModelSizeStats.TOTAL_OVER_FIELD_COUNT_FIELD.getPreferredName()).field(TYPE, LONG).endObject().startObject(ModelSizeStats.TOTAL_PARTITION_FIELD_COUNT_FIELD.getPreferredName()).field(TYPE, LONG).endObject().startObject(ModelSizeStats.BUCKET_ALLOCATION_FAILURES_COUNT_FIELD.getPreferredName()).field(TYPE, LONG).endObject().startObject(ModelSizeStats.MEMORY_STATUS_FIELD.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(ModelSizeStats.LOG_TIME_FIELD.getPreferredName()).field(TYPE, DATE).endObject();
        return builder;
    }

    public static XContentBuilder auditMessageMapping() throws IOException {
        return XContentFactory.jsonBuilder().startObject().startObject(AuditMessage.TYPE.getPreferredName()).startObject(PROPERTIES).startObject(Job.ID.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AuditMessage.LEVEL.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AuditMessage.MESSAGE.getPreferredName()).field(TYPE, TEXT).startObject(FIELDS).startObject(RAW).field(TYPE, KEYWORD).endObject().endObject().endObject().startObject(AuditMessage.TIMESTAMP.getPreferredName()).field(TYPE, DATE).endObject().startObject(AuditMessage.NODE_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().endObject().endObject().endObject();
    }
}

