/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import org.elasticsearch.client.Client;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.xpack.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.ml.job.persistence.BatchedDocumentsIterator;
import org.elasticsearch.xpack.ml.job.results.Result;

public abstract class BatchedResultsIterator<T>
extends BatchedDocumentsIterator<ResultWithIndex<T>> {
    public BatchedResultsIterator(Client client, String jobId, String resultType) {
        super(client, AnomalyDetectorsIndex.jobResultsAliasedName(jobId), (QueryBuilder)new TermsQueryBuilder(Result.RESULT_TYPE.getPreferredName(), new String[]{resultType}));
    }

    @Override
    protected String getType() {
        return Result.TYPE.getPreferredName();
    }

    public static class ResultWithIndex<T> {
        public final String indexName;
        public final T result;

        public ResultWithIndex(String indexName, T result) {
            this.indexName = indexName;
            this.result = result;
        }
    }
}

