/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.xpack.ml.job.persistence.JobProvider;
import org.elasticsearch.xpack.ml.job.persistence.ResultsFilterBuilder;
import org.elasticsearch.xpack.ml.job.results.Result;

public abstract class BatchedDocumentsIterator<T> {
    private static final Logger LOGGER = Loggers.getLogger(BatchedDocumentsIterator.class);
    private static final String CONTEXT_ALIVE_DURATION = "5m";
    private static final int BATCH_SIZE = 10000;
    private final Client client;
    private final String index;
    private final ResultsFilterBuilder filterBuilder;
    private volatile long count;
    private volatile long totalHits;
    private volatile String scrollId;
    private volatile boolean isScrollInitialised;

    public BatchedDocumentsIterator(Client client, String index) {
        this(client, index, new ResultsFilterBuilder());
    }

    protected BatchedDocumentsIterator(Client client, String index, QueryBuilder queryBuilder) {
        this(client, index, new ResultsFilterBuilder(queryBuilder));
    }

    private BatchedDocumentsIterator(Client client, String index, ResultsFilterBuilder resultsFilterBuilder) {
        this.client = Objects.requireNonNull(client);
        this.index = Objects.requireNonNull(index);
        this.totalHits = 0L;
        this.count = 0L;
        this.filterBuilder = Objects.requireNonNull(resultsFilterBuilder);
        this.isScrollInitialised = false;
    }

    public BatchedDocumentsIterator<T> timeRange(long startEpochMs, long endEpochMs) {
        this.filterBuilder.timeRange(Result.TIMESTAMP.getPreferredName(), startEpochMs, endEpochMs);
        return this;
    }

    public BatchedDocumentsIterator<T> includeInterim(String interimFieldName) {
        this.filterBuilder.interim(interimFieldName, true);
        return this;
    }

    public boolean hasNext() {
        return !this.isScrollInitialised || this.count != this.totalHits;
    }

    public Deque<T> next() {
        SearchResponse searchResponse;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.scrollId == null) {
            searchResponse = this.initScroll();
        } else {
            SearchScrollRequest searchScrollRequest = new SearchScrollRequest(this.scrollId).scroll(CONTEXT_ALIVE_DURATION);
            searchResponse = (SearchResponse)this.client.searchScroll(searchScrollRequest).actionGet();
        }
        this.scrollId = searchResponse.getScrollId();
        return this.mapHits(searchResponse);
    }

    private SearchResponse initScroll() {
        LOGGER.trace("ES API CALL: search all of type {} from index {}", (Object)this.getType(), (Object)this.index);
        this.isScrollInitialised = true;
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index});
        searchRequest.indicesOptions(JobProvider.addIgnoreUnavailable(SearchRequest.DEFAULT_INDICES_OPTIONS));
        searchRequest.types(new String[]{this.getType()});
        searchRequest.scroll(CONTEXT_ALIVE_DURATION);
        searchRequest.source(new SearchSourceBuilder().size(10000).query(this.filterBuilder.build()).sort((SortBuilder)SortBuilders.fieldSort((String)"_doc")));
        SearchResponse searchResponse = (SearchResponse)this.client.search(searchRequest).actionGet();
        this.totalHits = searchResponse.getHits().getTotalHits();
        this.scrollId = searchResponse.getScrollId();
        return searchResponse;
    }

    private Deque<T> mapHits(SearchResponse searchResponse) {
        SearchHit[] hits;
        ArrayDeque<T> results = new ArrayDeque<T>();
        for (SearchHit hit : hits = searchResponse.getHits().getHits()) {
            T mapped = this.map(hit);
            if (mapped == null) continue;
            results.add(mapped);
        }
        this.count += (long)hits.length;
        if (!this.hasNext() && this.scrollId != null) {
            this.client.prepareClearScroll().setScrollIds(Arrays.asList(this.scrollId)).get();
        }
        return results;
    }

    protected abstract String getType();

    protected abstract T map(SearchHit var1);
}

