/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.ml.job.persistence.BatchedResultsIterator;
import org.elasticsearch.xpack.ml.job.results.Bucket;

class BatchedBucketsIterator
extends BatchedResultsIterator<Bucket> {
    BatchedBucketsIterator(Client client, String jobId) {
        super(client, jobId, "bucket");
    }

    @Override
    protected BatchedResultsIterator.ResultWithIndex<Bucket> map(SearchHit hit) {
        XContentParser parser;
        BytesReference source = hit.getSourceRef();
        try {
            parser = XContentFactory.xContent((BytesReference)source).createParser(NamedXContentRegistry.EMPTY, source);
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to parse bucket", (Throwable)e, new Object[0]);
        }
        Bucket bucket = (Bucket)((Object)Bucket.PARSER.apply(parser, null));
        return new BatchedResultsIterator.ResultWithIndex<Bucket>(hit.getIndex(), bucket);
    }
}

