/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.support.ToXContentToBytes;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class MlFilter
extends ToXContentToBytes
implements Writeable {
    public static final ParseField TYPE = new ParseField("filter", new String[0]);
    public static final ParseField ID = new ParseField("id", new String[0]);
    public static final ParseField ITEMS = new ParseField("items", new String[0]);
    public static final ParseField RESULTS_FIELD = new ParseField("filters", new String[0]);
    public static final ConstructingObjectParser<MlFilter, Void> PARSER = new ConstructingObjectParser(TYPE.getPreferredName(), a -> new MlFilter((String)a[0], (List)a[1]));
    private final String id;
    private final List<String> items;

    public MlFilter(String id, List<String> items) {
        this.id = Objects.requireNonNull(id, ID.getPreferredName() + " must not be null");
        this.items = Objects.requireNonNull(items, ITEMS.getPreferredName() + " must not be null");
    }

    public MlFilter(StreamInput in) throws IOException {
        this.id = in.readString();
        this.items = Arrays.asList(in.readStringArray());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeStringArray(this.items.toArray(new String[this.items.size()]));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ID.getPreferredName(), this.id);
        builder.field(ITEMS.getPreferredName(), this.items);
        builder.endObject();
        return builder;
    }

    public String getId() {
        return this.id;
    }

    public List<String> getItems() {
        return new ArrayList<String>(this.items);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MlFilter)) {
            return false;
        }
        MlFilter other = (MlFilter)((Object)obj);
        return this.id.equals(other.id) && this.items.equals(other.items);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.items);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ID);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), ITEMS);
    }
}

