/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.config;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.ml.job.config.AnalysisConfig;
import org.elasticsearch.xpack.ml.job.config.AnalysisLimits;
import org.elasticsearch.xpack.ml.job.config.DetectionRule;
import org.elasticsearch.xpack.ml.job.config.Detector;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.config.ModelPlotConfig;

public class JobUpdate
implements Writeable,
ToXContent {
    public static final ParseField DETECTORS = new ParseField("detectors", new String[0]);
    public static final ConstructingObjectParser<Builder, Void> PARSER = new ConstructingObjectParser("job_update", args -> new Builder((String)args[0]));
    private final String jobId;
    private final String description;
    private final List<DetectorUpdate> detectorUpdates;
    private final ModelPlotConfig modelPlotConfig;
    private final AnalysisLimits analysisLimits;
    private final Long renormalizationWindowDays;
    private final TimeValue backgroundPersistInterval;
    private final Long modelSnapshotRetentionDays;
    private final Long resultsRetentionDays;
    private final List<String> categorizationFilters;
    private final Map<String, Object> customSettings;
    private final String modelSnapshotId;

    private JobUpdate(String jobId, @Nullable String description, @Nullable List<DetectorUpdate> detectorUpdates, @Nullable ModelPlotConfig modelPlotConfig, @Nullable AnalysisLimits analysisLimits, @Nullable TimeValue backgroundPersistInterval, @Nullable Long renormalizationWindowDays, @Nullable Long resultsRetentionDays, @Nullable Long modelSnapshotRetentionDays, @Nullable List<String> categorisationFilters, @Nullable Map<String, Object> customSettings, @Nullable String modelSnapshotId) {
        this.jobId = jobId;
        this.description = description;
        this.detectorUpdates = detectorUpdates;
        this.modelPlotConfig = modelPlotConfig;
        this.analysisLimits = analysisLimits;
        this.renormalizationWindowDays = renormalizationWindowDays;
        this.backgroundPersistInterval = backgroundPersistInterval;
        this.modelSnapshotRetentionDays = modelSnapshotRetentionDays;
        this.resultsRetentionDays = resultsRetentionDays;
        this.categorizationFilters = categorisationFilters;
        this.customSettings = customSettings;
        this.modelSnapshotId = modelSnapshotId;
    }

    public JobUpdate(StreamInput in) throws IOException {
        this.jobId = in.readString();
        this.description = in.readOptionalString();
        this.detectorUpdates = in.readBoolean() ? in.readList(DetectorUpdate::new) : null;
        this.modelPlotConfig = (ModelPlotConfig)in.readOptionalWriteable(ModelPlotConfig::new);
        this.analysisLimits = (AnalysisLimits)in.readOptionalWriteable(AnalysisLimits::new);
        this.renormalizationWindowDays = in.readOptionalLong();
        this.backgroundPersistInterval = (TimeValue)in.readOptionalWriteable(TimeValue::new);
        this.modelSnapshotRetentionDays = in.readOptionalLong();
        this.resultsRetentionDays = in.readOptionalLong();
        this.categorizationFilters = in.readBoolean() ? in.readList(StreamInput::readString) : null;
        this.customSettings = in.readMap();
        this.modelSnapshotId = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        out.writeOptionalString(this.description);
        out.writeBoolean(this.detectorUpdates != null);
        if (this.detectorUpdates != null) {
            out.writeList(this.detectorUpdates);
        }
        out.writeOptionalWriteable((Writeable)this.modelPlotConfig);
        out.writeOptionalWriteable((Writeable)this.analysisLimits);
        out.writeOptionalLong(this.renormalizationWindowDays);
        out.writeOptionalWriteable((Writeable)this.backgroundPersistInterval);
        out.writeOptionalLong(this.modelSnapshotRetentionDays);
        out.writeOptionalLong(this.resultsRetentionDays);
        out.writeBoolean(this.categorizationFilters != null);
        if (this.categorizationFilters != null) {
            out.writeStringList(this.categorizationFilters);
        }
        out.writeMap(this.customSettings);
        out.writeOptionalString(this.modelSnapshotId);
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getDescription() {
        return this.description;
    }

    public List<DetectorUpdate> getDetectorUpdates() {
        return this.detectorUpdates;
    }

    public ModelPlotConfig getModelPlotConfig() {
        return this.modelPlotConfig;
    }

    public AnalysisLimits getAnalysisLimits() {
        return this.analysisLimits;
    }

    public Long getRenormalizationWindowDays() {
        return this.renormalizationWindowDays;
    }

    public TimeValue getBackgroundPersistInterval() {
        return this.backgroundPersistInterval;
    }

    public Long getModelSnapshotRetentionDays() {
        return this.modelSnapshotRetentionDays;
    }

    public Long getResultsRetentionDays() {
        return this.resultsRetentionDays;
    }

    public List<String> getCategorizationFilters() {
        return this.categorizationFilters;
    }

    public Map<String, Object> getCustomSettings() {
        return this.customSettings;
    }

    public String getModelSnapshotId() {
        return this.modelSnapshotId;
    }

    public boolean isAutodetectProcessUpdate() {
        return this.modelPlotConfig != null || this.detectorUpdates != null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        if (this.description != null) {
            builder.field(Job.DESCRIPTION.getPreferredName(), this.description);
        }
        if (this.detectorUpdates != null) {
            builder.field(DETECTORS.getPreferredName(), this.detectorUpdates);
        }
        if (this.modelPlotConfig != null) {
            builder.field(Job.MODEL_PLOT_CONFIG.getPreferredName(), (ToXContent)this.modelPlotConfig);
        }
        if (this.analysisLimits != null) {
            builder.field(Job.ANALYSIS_LIMITS.getPreferredName(), (ToXContent)this.analysisLimits);
        }
        if (this.renormalizationWindowDays != null) {
            builder.field(Job.RENORMALIZATION_WINDOW_DAYS.getPreferredName(), this.renormalizationWindowDays);
        }
        if (this.backgroundPersistInterval != null) {
            builder.field(Job.BACKGROUND_PERSIST_INTERVAL.getPreferredName(), (Object)this.backgroundPersistInterval);
        }
        if (this.modelSnapshotRetentionDays != null) {
            builder.field(Job.MODEL_SNAPSHOT_RETENTION_DAYS.getPreferredName(), this.modelSnapshotRetentionDays);
        }
        if (this.resultsRetentionDays != null) {
            builder.field(Job.RESULTS_RETENTION_DAYS.getPreferredName(), this.resultsRetentionDays);
        }
        if (this.categorizationFilters != null) {
            builder.field(AnalysisConfig.CATEGORIZATION_FILTERS.getPreferredName(), this.categorizationFilters);
        }
        if (this.customSettings != null) {
            builder.field(Job.CUSTOM_SETTINGS.getPreferredName(), this.customSettings);
        }
        if (this.modelSnapshotId != null) {
            builder.field(Job.MODEL_SNAPSHOT_ID.getPreferredName(), this.modelSnapshotId);
        }
        builder.endObject();
        return builder;
    }

    public Job mergeWithJob(Job source) {
        Job.Builder builder = new Job.Builder(source);
        if (this.description != null) {
            builder.setDescription(this.description);
        }
        if (this.detectorUpdates != null && !this.detectorUpdates.isEmpty()) {
            AnalysisConfig ac = source.getAnalysisConfig();
            int numDetectors = ac.getDetectors().size();
            for (DetectorUpdate dd : this.detectorUpdates) {
                if (dd.getIndex() >= numDetectors) {
                    throw new IllegalArgumentException("Detector index is >= the number of detectors");
                }
                Detector.Builder detectorbuilder = new Detector.Builder(ac.getDetectors().get(dd.getIndex()));
                if (dd.getDescription() != null) {
                    detectorbuilder.setDetectorDescription(dd.getDescription());
                }
                if (dd.getRules() != null) {
                    detectorbuilder.setDetectorRules(dd.getRules());
                }
                ac.getDetectors().set(dd.getIndex(), detectorbuilder.build());
            }
            AnalysisConfig.Builder acBuilder = new AnalysisConfig.Builder(ac);
            builder.setAnalysisConfig(acBuilder);
        }
        if (this.modelPlotConfig != null) {
            builder.setModelPlotConfig(this.modelPlotConfig);
        }
        if (this.analysisLimits != null) {
            builder.setAnalysisLimits(this.analysisLimits);
        }
        if (this.renormalizationWindowDays != null) {
            builder.setRenormalizationWindowDays(this.renormalizationWindowDays);
        }
        if (this.backgroundPersistInterval != null) {
            builder.setBackgroundPersistInterval(this.backgroundPersistInterval);
        }
        if (this.modelSnapshotRetentionDays != null) {
            builder.setModelSnapshotRetentionDays(this.modelSnapshotRetentionDays);
        }
        if (this.resultsRetentionDays != null) {
            builder.setResultsRetentionDays(this.resultsRetentionDays);
        }
        if (this.categorizationFilters != null) {
            AnalysisConfig.Builder analysisConfigBuilder = new AnalysisConfig.Builder(source.getAnalysisConfig());
            analysisConfigBuilder.setCategorizationFilters(this.categorizationFilters);
            builder.setAnalysisConfig(analysisConfigBuilder);
        }
        if (this.customSettings != null) {
            builder.setCustomSettings(this.customSettings);
        }
        if (this.modelSnapshotId != null) {
            builder.setModelSnapshotId(this.modelSnapshotId);
        }
        return builder.build();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JobUpdate)) {
            return false;
        }
        JobUpdate that = (JobUpdate)other;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.description, that.description) && Objects.equals(this.detectorUpdates, that.detectorUpdates) && Objects.equals((Object)this.modelPlotConfig, (Object)that.modelPlotConfig) && Objects.equals((Object)this.analysisLimits, (Object)that.analysisLimits) && Objects.equals(this.renormalizationWindowDays, that.renormalizationWindowDays) && Objects.equals(this.backgroundPersistInterval, that.backgroundPersistInterval) && Objects.equals(this.modelSnapshotRetentionDays, that.modelSnapshotRetentionDays) && Objects.equals(this.resultsRetentionDays, that.resultsRetentionDays) && Objects.equals(this.categorizationFilters, that.categorizationFilters) && Objects.equals(this.customSettings, that.customSettings) && Objects.equals(this.modelSnapshotId, that.modelSnapshotId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jobId, this.description, this.detectorUpdates, this.modelPlotConfig, this.analysisLimits, this.renormalizationWindowDays, this.backgroundPersistInterval, this.modelSnapshotRetentionDays, this.resultsRetentionDays, this.categorizationFilters, this.customSettings, this.modelSnapshotId});
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), Job.ID);
        PARSER.declareStringOrNull(Builder::setDescription, Job.DESCRIPTION);
        PARSER.declareObjectArray(Builder::setDetectorUpdates, DetectorUpdate.PARSER, DETECTORS);
        PARSER.declareObject(Builder::setModelPlotConfig, ModelPlotConfig.PARSER, Job.MODEL_PLOT_CONFIG);
        PARSER.declareObject(Builder::setAnalysisLimits, AnalysisLimits.PARSER, Job.ANALYSIS_LIMITS);
        PARSER.declareString((builder, val) -> builder.setBackgroundPersistInterval(TimeValue.parseTimeValue((String)val, (String)Job.BACKGROUND_PERSIST_INTERVAL.getPreferredName())), Job.BACKGROUND_PERSIST_INTERVAL);
        PARSER.declareLong(Builder::setRenormalizationWindowDays, Job.RENORMALIZATION_WINDOW_DAYS);
        PARSER.declareLong(Builder::setResultsRetentionDays, Job.RESULTS_RETENTION_DAYS);
        PARSER.declareLong(Builder::setModelSnapshotRetentionDays, Job.MODEL_SNAPSHOT_RETENTION_DAYS);
        PARSER.declareStringArray(Builder::setCategorizationFilters, AnalysisConfig.CATEGORIZATION_FILTERS);
        PARSER.declareField(Builder::setCustomSettings, (p, c) -> p.map(), Job.CUSTOM_SETTINGS, ObjectParser.ValueType.OBJECT);
        PARSER.declareString(Builder::setModelSnapshotId, Job.MODEL_SNAPSHOT_ID);
    }

    public static class Builder {
        private String jobId;
        private String description;
        private List<DetectorUpdate> detectorUpdates;
        private ModelPlotConfig modelPlotConfig;
        private AnalysisLimits analysisLimits;
        private Long renormalizationWindowDays;
        private TimeValue backgroundPersistInterval;
        private Long modelSnapshotRetentionDays;
        private Long resultsRetentionDays;
        private List<String> categorizationFilters;
        private Map<String, Object> customSettings;
        private String modelSnapshotId;

        public Builder(String jobId) {
            this.jobId = jobId;
        }

        public Builder setJobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setDetectorUpdates(List<DetectorUpdate> detectorUpdates) {
            this.detectorUpdates = detectorUpdates;
            return this;
        }

        public Builder setModelPlotConfig(ModelPlotConfig modelPlotConfig) {
            this.modelPlotConfig = modelPlotConfig;
            return this;
        }

        public Builder setAnalysisLimits(AnalysisLimits analysisLimits) {
            this.analysisLimits = analysisLimits;
            return this;
        }

        public Builder setRenormalizationWindowDays(Long renormalizationWindowDays) {
            this.renormalizationWindowDays = renormalizationWindowDays;
            return this;
        }

        public Builder setBackgroundPersistInterval(TimeValue backgroundPersistInterval) {
            this.backgroundPersistInterval = backgroundPersistInterval;
            return this;
        }

        public Builder setModelSnapshotRetentionDays(Long modelSnapshotRetentionDays) {
            this.modelSnapshotRetentionDays = modelSnapshotRetentionDays;
            return this;
        }

        public Builder setResultsRetentionDays(Long resultsRetentionDays) {
            this.resultsRetentionDays = resultsRetentionDays;
            return this;
        }

        public Builder setCategorizationFilters(List<String> categorizationFilters) {
            this.categorizationFilters = categorizationFilters;
            return this;
        }

        public Builder setCustomSettings(Map<String, Object> customSettings) {
            this.customSettings = customSettings;
            return this;
        }

        public Builder setModelSnapshotId(String modelSnapshotId) {
            this.modelSnapshotId = modelSnapshotId;
            return this;
        }

        public JobUpdate build() {
            return new JobUpdate(this.jobId, this.description, this.detectorUpdates, this.modelPlotConfig, this.analysisLimits, this.backgroundPersistInterval, this.renormalizationWindowDays, this.resultsRetentionDays, this.modelSnapshotRetentionDays, this.categorizationFilters, this.customSettings, this.modelSnapshotId);
        }
    }

    public static class DetectorUpdate
    implements Writeable,
    ToXContent {
        public static final ConstructingObjectParser<DetectorUpdate, Void> PARSER = new ConstructingObjectParser("detector_update", a -> new DetectorUpdate((Integer)a[0], (String)a[1], (List)a[2]));
        public static final ParseField INDEX = new ParseField("index", new String[0]);
        public static final ParseField RULES = new ParseField("rules", new String[0]);
        private int index;
        private String description;
        private List<DetectionRule> rules;

        public DetectorUpdate(int index, String description, List<DetectionRule> rules) {
            this.index = index;
            this.description = description;
            this.rules = rules;
        }

        public DetectorUpdate(StreamInput in) throws IOException {
            this.index = in.readInt();
            this.description = in.readOptionalString();
            this.rules = in.readBoolean() ? in.readList(DetectionRule::new) : null;
        }

        public int getIndex() {
            return this.index;
        }

        public String getDescription() {
            return this.description;
        }

        public List<DetectionRule> getRules() {
            return this.rules;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeInt(this.index);
            out.writeOptionalString(this.description);
            out.writeBoolean(this.rules != null);
            if (this.rules != null) {
                out.writeList(this.rules);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(INDEX.getPreferredName(), this.index);
            if (this.description != null) {
                builder.field(Job.DESCRIPTION.getPreferredName(), this.description);
            }
            if (this.rules != null) {
                builder.field(RULES.getPreferredName(), this.rules);
            }
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.index, this.description, this.rules);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DetectorUpdate)) {
                return false;
            }
            DetectorUpdate that = (DetectorUpdate)other;
            return this.index == that.index && Objects.equals(this.description, that.description) && Objects.equals(this.rules, that.rules);
        }

        static {
            PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), INDEX);
            PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), Job.DESCRIPTION);
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (parser, parseFieldMatcher) -> ((DetectionRule.Builder)DetectionRule.PARSER.apply(parser, parseFieldMatcher)).build(), RULES);
        }
    }
}

