/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed;

import java.util.Objects;
import org.elasticsearch.xpack.ml.job.messages.Messages;
import org.elasticsearch.xpack.ml.notifications.Auditor;

class ProblemTracker {
    private static final int EMPTY_DATA_WARN_COUNT = 10;
    private final Auditor auditor;
    private final String jobId;
    private volatile boolean hasProblems;
    private volatile boolean hadProblems;
    private volatile String previousProblem;
    private volatile int emptyDataCount;

    ProblemTracker(Auditor auditor, String jobId) {
        this.auditor = Objects.requireNonNull(auditor);
        this.jobId = Objects.requireNonNull(jobId);
    }

    public void reportAnalysisProblem(String problemMessage) {
        this.reportProblem("Datafeed is encountering errors submitting data for analysis: {0}", problemMessage);
    }

    public void reportExtractionProblem(String problemMessage) {
        this.reportProblem("Datafeed is encountering errors extracting data: {0}", problemMessage);
    }

    private void reportProblem(String template, String problemMessage) {
        this.hasProblems = true;
        if (!Objects.equals(this.previousProblem, problemMessage)) {
            this.previousProblem = problemMessage;
            this.auditor.error(this.jobId, Messages.getMessage(template, problemMessage));
        }
    }

    public void reportEmptyDataCount() {
        if (this.emptyDataCount < 10) {
            ++this.emptyDataCount;
            if (this.emptyDataCount == 10) {
                this.auditor.warning(this.jobId, Messages.getMessage("Datafeed has been retrieving no data for a while"));
            }
        }
    }

    public void reportNoneEmptyCount() {
        if (this.emptyDataCount >= 10) {
            this.auditor.info(this.jobId, Messages.getMessage("Datafeed has started retrieving data again"));
        }
        this.emptyDataCount = 0;
    }

    public boolean hasProblems() {
        return this.hasProblems;
    }

    public void finishReport() {
        if (!this.hasProblems && this.hadProblems) {
            this.auditor.info(this.jobId, Messages.getMessage("Datafeed has recovered data extraction and analysis"));
        }
        this.hadProblems = this.hasProblems;
        this.hasProblems = false;
    }
}

