/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed;

import java.time.Duration;

public final class DefaultFrequency {
    private static final int SECONDS_IN_MINUTE = 60;
    private static final int TWO_MINS_SECONDS = 120;
    private static final int TWENTY_MINS_SECONDS = 1200;
    private static final int HALF_DAY_SECONDS = 43200;
    private static final Duration TEN_MINUTES = Duration.ofMinutes(10L);
    private static final Duration ONE_HOUR = Duration.ofHours(1L);

    private DefaultFrequency() {
    }

    public static Duration ofBucketSpan(long bucketSpanSeconds) {
        if (bucketSpanSeconds <= 0L) {
            throw new IllegalArgumentException("Bucket span has to be > 0");
        }
        if (bucketSpanSeconds <= 120L) {
            return Duration.ofSeconds(60L);
        }
        if (bucketSpanSeconds <= 1200L) {
            return Duration.ofSeconds(bucketSpanSeconds / 2L);
        }
        if (bucketSpanSeconds <= 43200L) {
            return TEN_MINUTES;
        }
        return ONE_HOUR;
    }
}

