/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.ml.datafeed.ChunkingConfig;
import org.elasticsearch.xpack.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;

public class DatafeedUpdate
implements Writeable,
ToXContent {
    public static final ObjectParser<Builder, Void> PARSER = new ObjectParser("datafeed_update", Builder::new);
    private final String id;
    private final String jobId;
    private final TimeValue queryDelay;
    private final TimeValue frequency;
    private final List<String> indexes;
    private final List<String> types;
    private final QueryBuilder query;
    private final AggregatorFactories.Builder aggregations;
    private final List<SearchSourceBuilder.ScriptField> scriptFields;
    private final Integer scrollSize;
    private final Boolean source;
    private final ChunkingConfig chunkingConfig;

    private DatafeedUpdate(String id, String jobId, TimeValue queryDelay, TimeValue frequency, List<String> indexes, List<String> types, QueryBuilder query, AggregatorFactories.Builder aggregations, List<SearchSourceBuilder.ScriptField> scriptFields, Integer scrollSize, Boolean source, ChunkingConfig chunkingConfig) {
        this.id = id;
        this.jobId = jobId;
        this.queryDelay = queryDelay;
        this.frequency = frequency;
        this.indexes = indexes;
        this.types = types;
        this.query = query;
        this.aggregations = aggregations;
        this.scriptFields = scriptFields;
        this.scrollSize = scrollSize;
        this.source = source;
        this.chunkingConfig = chunkingConfig;
    }

    public DatafeedUpdate(StreamInput in) throws IOException {
        this.id = in.readString();
        this.jobId = in.readOptionalString();
        this.queryDelay = (TimeValue)in.readOptionalWriteable(TimeValue::new);
        this.frequency = (TimeValue)in.readOptionalWriteable(TimeValue::new);
        this.indexes = in.readBoolean() ? in.readList(StreamInput::readString) : null;
        this.types = in.readBoolean() ? in.readList(StreamInput::readString) : null;
        this.query = (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class);
        this.aggregations = (AggregatorFactories.Builder)in.readOptionalWriteable(AggregatorFactories.Builder::new);
        this.scriptFields = in.readBoolean() ? in.readList(SearchSourceBuilder.ScriptField::new) : null;
        this.scrollSize = in.readOptionalVInt();
        this.source = in.readOptionalBoolean();
        this.chunkingConfig = (ChunkingConfig)in.readOptionalWriteable(ChunkingConfig::new);
    }

    public String getId() {
        return this.id;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeOptionalString(this.jobId);
        out.writeOptionalWriteable((Writeable)this.queryDelay);
        out.writeOptionalWriteable((Writeable)this.frequency);
        if (this.indexes != null) {
            out.writeBoolean(true);
            out.writeStringList(this.indexes);
        } else {
            out.writeBoolean(false);
        }
        if (this.types != null) {
            out.writeBoolean(true);
            out.writeStringList(this.types);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalNamedWriteable((NamedWriteable)this.query);
        out.writeOptionalWriteable((Writeable)this.aggregations);
        if (this.scriptFields != null) {
            out.writeBoolean(true);
            out.writeList(this.scriptFields);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalVInt(this.scrollSize);
        out.writeOptionalBoolean(this.source);
        out.writeOptionalWriteable((Writeable)this.chunkingConfig);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DatafeedConfig.ID.getPreferredName(), this.id);
        this.addOptionalField(builder, Job.ID, this.jobId);
        if (this.queryDelay != null) {
            builder.field(DatafeedConfig.QUERY_DELAY.getPreferredName(), this.queryDelay.getStringRep());
        }
        if (this.frequency != null) {
            builder.field(DatafeedConfig.FREQUENCY.getPreferredName(), this.frequency.getStringRep());
        }
        this.addOptionalField(builder, DatafeedConfig.INDEXES, this.indexes);
        this.addOptionalField(builder, DatafeedConfig.TYPES, this.types);
        this.addOptionalField(builder, DatafeedConfig.QUERY, this.query);
        this.addOptionalField(builder, DatafeedConfig.AGGREGATIONS, this.aggregations);
        if (this.scriptFields != null) {
            builder.startObject(DatafeedConfig.SCRIPT_FIELDS.getPreferredName());
            for (SearchSourceBuilder.ScriptField scriptField : this.scriptFields) {
                scriptField.toXContent(builder, params);
            }
            builder.endObject();
        }
        this.addOptionalField(builder, DatafeedConfig.SCROLL_SIZE, this.scrollSize);
        this.addOptionalField(builder, DatafeedConfig.SOURCE, this.source);
        this.addOptionalField(builder, DatafeedConfig.CHUNKING_CONFIG, (Object)this.chunkingConfig);
        builder.endObject();
        return builder;
    }

    private void addOptionalField(XContentBuilder builder, ParseField field, Object value) throws IOException {
        if (value != null) {
            builder.field(field.getPreferredName(), value);
        }
    }

    public DatafeedConfig apply(DatafeedConfig datafeedConfig) {
        if (!this.id.equals(datafeedConfig.getId())) {
            throw new IllegalArgumentException("Cannot apply update to datafeedConfig with different id");
        }
        DatafeedConfig.Builder builder = new DatafeedConfig.Builder(datafeedConfig);
        if (this.jobId != null) {
            builder.setJobId(this.jobId);
        }
        if (this.queryDelay != null) {
            builder.setQueryDelay(this.queryDelay);
        }
        if (this.frequency != null) {
            builder.setFrequency(this.frequency);
        }
        if (this.indexes != null) {
            builder.setIndexes(this.indexes);
        }
        if (this.types != null) {
            builder.setTypes(this.types);
        }
        if (this.query != null) {
            builder.setQuery(this.query);
        }
        if (this.aggregations != null) {
            builder.setAggregations(this.aggregations);
        }
        if (this.scriptFields != null) {
            builder.setScriptFields(this.scriptFields);
        }
        if (this.scrollSize != null) {
            builder.setScrollSize(this.scrollSize);
        }
        if (this.source != null) {
            builder.setSource(this.source);
        }
        if (this.chunkingConfig != null) {
            builder.setChunkingConfig(this.chunkingConfig);
        }
        return builder.build();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DatafeedUpdate)) {
            return false;
        }
        DatafeedUpdate that = (DatafeedUpdate)other;
        return Objects.equals(this.id, that.id) && Objects.equals(this.jobId, that.jobId) && Objects.equals(this.frequency, that.frequency) && Objects.equals(this.queryDelay, that.queryDelay) && Objects.equals(this.indexes, that.indexes) && Objects.equals(this.types, that.types) && Objects.equals(this.query, that.query) && Objects.equals(this.scrollSize, that.scrollSize) && Objects.equals(this.aggregations, that.aggregations) && Objects.equals(this.scriptFields, that.scriptFields) && Objects.equals(this.source, that.source) && Objects.equals((Object)this.chunkingConfig, (Object)that.chunkingConfig);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.jobId, this.frequency, this.queryDelay, this.indexes, this.types, this.query, this.scrollSize, this.aggregations, this.scriptFields, this.source, this.chunkingConfig});
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareString(Builder::setId, DatafeedConfig.ID);
        PARSER.declareString(Builder::setJobId, Job.ID);
        PARSER.declareStringArray(Builder::setIndexes, DatafeedConfig.INDEXES);
        PARSER.declareStringArray(Builder::setTypes, DatafeedConfig.TYPES);
        PARSER.declareString((builder, val) -> builder.setQueryDelay(TimeValue.parseTimeValue((String)val, (String)DatafeedConfig.QUERY_DELAY.getPreferredName())), DatafeedConfig.QUERY_DELAY);
        PARSER.declareString((builder, val) -> builder.setFrequency(TimeValue.parseTimeValue((String)val, (String)DatafeedConfig.FREQUENCY.getPreferredName())), DatafeedConfig.FREQUENCY);
        PARSER.declareObject(Builder::setQuery, (p, c) -> (QueryBuilder)new QueryParseContext(p).parseInnerQueryBuilder().get(), DatafeedConfig.QUERY);
        PARSER.declareObject(Builder::setAggregations, (p, c) -> AggregatorFactories.parseAggregators((QueryParseContext)new QueryParseContext(p)), DatafeedConfig.AGGREGATIONS);
        PARSER.declareObject(Builder::setAggregations, (p, c) -> AggregatorFactories.parseAggregators((QueryParseContext)new QueryParseContext(p)), DatafeedConfig.AGGS);
        PARSER.declareObject(Builder::setScriptFields, (p, c) -> {
            ArrayList<SearchSourceBuilder.ScriptField> parsedScriptFields = new ArrayList<SearchSourceBuilder.ScriptField>();
            while (p.nextToken() != XContentParser.Token.END_OBJECT) {
                parsedScriptFields.add(new SearchSourceBuilder.ScriptField(new QueryParseContext(p)));
            }
            parsedScriptFields.sort(Comparator.comparing(SearchSourceBuilder.ScriptField::fieldName));
            return parsedScriptFields;
        }, DatafeedConfig.SCRIPT_FIELDS);
        PARSER.declareInt(Builder::setScrollSize, DatafeedConfig.SCROLL_SIZE);
        PARSER.declareBoolean(Builder::setSource, DatafeedConfig.SOURCE);
        PARSER.declareObject(Builder::setChunkingConfig, ChunkingConfig.PARSER, DatafeedConfig.CHUNKING_CONFIG);
    }

    public static class Builder {
        private String id;
        private String jobId;
        private TimeValue queryDelay;
        private TimeValue frequency;
        private List<String> indexes;
        private List<String> types;
        private QueryBuilder query;
        private AggregatorFactories.Builder aggregations;
        private List<SearchSourceBuilder.ScriptField> scriptFields;
        private Integer scrollSize;
        private Boolean source;
        private ChunkingConfig chunkingConfig;

        public Builder() {
        }

        public Builder(String id) {
            this.id = ExceptionsHelper.requireNonNull(id, DatafeedConfig.ID.getPreferredName());
        }

        public Builder(DatafeedUpdate config) {
            this.id = config.id;
            this.jobId = config.jobId;
            this.queryDelay = config.queryDelay;
            this.frequency = config.frequency;
            this.indexes = config.indexes;
            this.types = config.types;
            this.query = config.query;
            this.aggregations = config.aggregations;
            this.scriptFields = config.scriptFields;
            this.scrollSize = config.scrollSize;
            this.source = config.source;
            this.chunkingConfig = config.chunkingConfig;
        }

        public void setId(String datafeedId) {
            this.id = ExceptionsHelper.requireNonNull(datafeedId, DatafeedConfig.ID.getPreferredName());
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public void setIndexes(List<String> indexes) {
            this.indexes = indexes;
        }

        public void setTypes(List<String> types) {
            this.types = types;
        }

        public void setQueryDelay(TimeValue queryDelay) {
            this.queryDelay = queryDelay;
        }

        public void setFrequency(TimeValue frequency) {
            this.frequency = frequency;
        }

        public void setQuery(QueryBuilder query) {
            this.query = query;
        }

        public void setAggregations(AggregatorFactories.Builder aggregations) {
            this.aggregations = aggregations;
        }

        public void setScriptFields(List<SearchSourceBuilder.ScriptField> scriptFields) {
            ArrayList<SearchSourceBuilder.ScriptField> sorted = new ArrayList<SearchSourceBuilder.ScriptField>(scriptFields);
            sorted.sort(Comparator.comparing(SearchSourceBuilder.ScriptField::fieldName));
            this.scriptFields = sorted;
        }

        public void setScrollSize(int scrollSize) {
            this.scrollSize = scrollSize;
        }

        public void setSource(boolean enabled) {
            this.source = enabled;
        }

        public void setChunkingConfig(ChunkingConfig chunkingConfig) {
            this.chunkingConfig = chunkingConfig;
        }

        public DatafeedUpdate build() {
            return new DatafeedUpdate(this.id, this.jobId, this.queryDelay, this.frequency, this.indexes, this.types, this.query, this.aggregations, this.scriptFields, this.scrollSize, this.source, this.chunkingConfig);
        }
    }
}

