/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.TransportBulkAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeOperationRequestBuilder;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.config.MlFilter;
import org.elasticsearch.xpack.ml.job.persistence.JobProvider;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;

public class PutFilterAction
extends Action<Request, Response, RequestBuilder> {
    public static final PutFilterAction INSTANCE = new PutFilterAction();
    public static final String NAME = "cluster:admin/xpack/ml/filters/put";

    private PutFilterAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class TransportAction
    extends HandledTransportAction<Request, Response> {
        private final TransportBulkAction transportBulkAction;

        @Inject
        public TransportAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, JobProvider jobProvider, JobManager jobManager, Client client, TransportBulkAction transportBulkAction) {
            super(settings, PutFilterAction.NAME, threadPool, transportService, actionFilters, indexNameExpressionResolver, Request::new);
            this.transportBulkAction = transportBulkAction;
        }

        protected void doExecute(Request request, final ActionListener<Response> listener) {
            MlFilter filter = request.getFilter();
            final String filterId = filter.getId();
            IndexRequest indexRequest = new IndexRequest(".ml-meta", MlFilter.TYPE.getPreferredName(), filterId);
            try (XContentBuilder builder = XContentFactory.jsonBuilder();){
                indexRequest.source(filter.toXContent(builder, ToXContent.EMPTY_PARAMS));
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to serialise filter with id [" + filter.getId() + "]", e);
            }
            BulkRequest bulkRequest = new BulkRequest().add(indexRequest);
            this.transportBulkAction.execute((ActionRequest)bulkRequest, (ActionListener)new ActionListener<BulkResponse>(){

                public void onResponse(BulkResponse indexResponse) {
                    listener.onResponse((Object)new Response());
                }

                public void onFailure(Exception e) {
                    listener.onFailure((Exception)new ResourceNotFoundException("Could not create filter with ID [" + filterId + "]", (Throwable)e, new Object[0]));
                }
            });
        }
    }

    public static class Response
    extends AcknowledgedResponse {
        public Response() {
            super(true);
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.readAcknowledged(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.writeAcknowledged(out);
        }
    }

    public static class RequestBuilder
    extends MasterNodeOperationRequestBuilder<Request, Response, RequestBuilder> {
        public RequestBuilder(ElasticsearchClient client, PutFilterAction action) {
            super(client, (Action)action, (MasterNodeRequest)new Request());
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request>
    implements ToXContent {
        private MlFilter filter;

        public static Request parseRequest(XContentParser parser) {
            MlFilter filter = (MlFilter)((Object)MlFilter.PARSER.apply(parser, null));
            return new Request(filter);
        }

        Request() {
        }

        public Request(MlFilter filter) {
            this.filter = ExceptionsHelper.requireNonNull(filter, "filter");
        }

        public MlFilter getFilter() {
            return this.filter;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.filter = new MlFilter(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.filter.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.filter.toXContent(builder, params);
            return builder;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.filter});
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals((Object)this.filter, (Object)other.filter);
        }
    }
}

