/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ml.MlMetadata;
import org.elasticsearch.xpack.ml.datafeed.ChunkingConfig;
import org.elasticsearch.xpack.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractor;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractorFactory;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;

public class PreviewDatafeedAction
extends Action<Request, Response, RequestBuilder> {
    public static final PreviewDatafeedAction INSTANCE = new PreviewDatafeedAction();
    public static final String NAME = "cluster:admin/xpack/ml/datafeeds/preview";

    private PreviewDatafeedAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class TransportAction
    extends HandledTransportAction<Request, Response> {
        private final Client client;
        private final ClusterService clusterService;

        @Inject
        public TransportAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, ClusterService clusterService) {
            super(settings, PreviewDatafeedAction.NAME, threadPool, transportService, actionFilters, indexNameExpressionResolver, Request::new);
            this.client = client;
            this.clusterService = clusterService;
        }

        protected void doExecute(Request request, ActionListener<Response> listener) {
            MlMetadata mlMetadata = (MlMetadata)this.clusterService.state().getMetaData().custom("ml");
            DatafeedConfig datafeed = mlMetadata.getDatafeed(request.getDatafeedId());
            if (datafeed == null) {
                throw ExceptionsHelper.missingDatafeedException(request.getDatafeedId());
            }
            Job job = mlMetadata.getJobs().get(datafeed.getJobId());
            if (job == null) {
                throw ExceptionsHelper.missingJobException(datafeed.getJobId());
            }
            DatafeedConfig.Builder datafeedWithAutoChunking = new DatafeedConfig.Builder(datafeed);
            datafeedWithAutoChunking.setChunkingConfig(ChunkingConfig.newAuto());
            DataExtractorFactory dataExtractorFactory = DataExtractorFactory.create(this.client, datafeedWithAutoChunking.build(), job);
            DataExtractor dataExtractor = dataExtractorFactory.newExtractor(0L, Long.MAX_VALUE);
            this.threadPool.generic().execute(() -> TransportAction.previewDatafeed(dataExtractor, listener));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void previewDatafeed(DataExtractor dataExtractor, ActionListener<Response> listener) {
            try {
                Optional<InputStream> inputStream = dataExtractor.next();
                StringBuilder responseBuilder = new StringBuilder("[");
                if (inputStream.isPresent()) {
                    try (BufferedReader buffer = new BufferedReader(new InputStreamReader(inputStream.get(), StandardCharsets.UTF_8));){
                        responseBuilder.append(buffer.lines().collect(Collectors.joining(" ")).replace("} {", "},{"));
                    }
                }
                responseBuilder.append("]");
                listener.onResponse((Object)new Response((BytesReference)new BytesArray(responseBuilder.toString().getBytes(StandardCharsets.UTF_8))));
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
            finally {
                dataExtractor.cancel();
            }
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private BytesReference preview;

        Response() {
        }

        Response(BytesReference preview) {
            this.preview = preview;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.preview = in.readBytesReference();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBytesReference(this.preview);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.rawValue(this.preview, XContentType.JSON);
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.preview);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(this.preview, other.preview);
        }

        public final String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    static class RequestBuilder
    extends ActionRequestBuilder<Request, Response, RequestBuilder> {
        RequestBuilder(ElasticsearchClient client) {
            super(client, (Action)INSTANCE, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends ActionRequest
    implements ToXContent {
        private String datafeedId;

        Request() {
        }

        public Request(String datafeedId) {
            this.setDatafeedId(datafeedId);
        }

        public String getDatafeedId() {
            return this.datafeedId;
        }

        public final void setDatafeedId(String datafeedId) {
            this.datafeedId = ExceptionsHelper.requireNonNull(datafeedId, DatafeedConfig.ID.getPreferredName());
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.datafeedId = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.datafeedId);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(DatafeedConfig.ID.getPreferredName(), this.datafeedId);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.datafeedId);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.datafeedId, other.datafeedId);
        }
    }
}

