/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ml.action.OpenJobAction;
import org.elasticsearch.xpack.ml.action.TransportJobTaskAction;
import org.elasticsearch.xpack.ml.job.config.DataDescription;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.DataLoadParams;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.TimeRange;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.DataCounts;

public class PostDataAction
extends Action<Request, Response, RequestBuilder> {
    public static final PostDataAction INSTANCE = new PostDataAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/data/post";

    private PostDataAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class TransportAction
    extends TransportJobTaskAction<Request, Response> {
        @Inject
        public TransportAction(Settings settings, TransportService transportService, ThreadPool threadPool, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AutodetectProcessManager processManager) {
            super(settings, PostDataAction.NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, Request::new, () -> new Response(), "same", processManager);
        }

        protected Response readTaskResponse(StreamInput in) throws IOException {
            Response response = new Response();
            response.readFrom(in);
            return response;
        }

        protected void taskOperation(Request request, OpenJobAction.JobTask task, ActionListener<Response> listener) {
            TimeRange timeRange = TimeRange.builder().startTime(request.getResetStart()).endTime(request.getResetEnd()).build();
            DataLoadParams params = new DataLoadParams(timeRange, Optional.ofNullable(request.getDataDescription()));
            try {
                this.processManager.processData(task, (InputStream)request.content.streamInput(), request.getXContentType(), params, (dataCounts, e) -> {
                    if (dataCounts != null) {
                        listener.onResponse((Object)new Response((DataCounts)((Object)dataCounts)));
                    } else {
                        listener.onFailure(e);
                    }
                });
            }
            catch (Exception e2) {
                listener.onFailure(e2);
            }
        }
    }

    public static class Request
    extends TransportJobTaskAction.JobTaskRequest<Request> {
        public static final ParseField RESET_START = new ParseField("reset_start", new String[0]);
        public static final ParseField RESET_END = new ParseField("reset_end", new String[0]);
        private String resetStart = "";
        private String resetEnd = "";
        private DataDescription dataDescription;
        private XContentType xContentType;
        private BytesReference content;

        Request() {
        }

        public Request(String jobId) {
            super(jobId);
        }

        public String getResetStart() {
            return this.resetStart;
        }

        public void setResetStart(String resetStart) {
            this.resetStart = resetStart;
        }

        public String getResetEnd() {
            return this.resetEnd;
        }

        public void setResetEnd(String resetEnd) {
            this.resetEnd = resetEnd;
        }

        public DataDescription getDataDescription() {
            return this.dataDescription;
        }

        public void setDataDescription(DataDescription dataDescription) {
            this.dataDescription = dataDescription;
        }

        public BytesReference getContent() {
            return this.content;
        }

        public XContentType getXContentType() {
            return this.xContentType;
        }

        public void setContent(BytesReference content, XContentType xContentType) {
            this.content = content;
            this.xContentType = xContentType;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.resetStart = in.readOptionalString();
            this.resetEnd = in.readOptionalString();
            this.dataDescription = (DataDescription)in.readOptionalWriteable(DataDescription::new);
            this.content = in.readBytesReference();
            if (in.readBoolean()) {
                this.xContentType = XContentType.readFrom((StreamInput)in);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalString(this.resetStart);
            out.writeOptionalString(this.resetEnd);
            out.writeOptionalWriteable((Writeable)this.dataDescription);
            out.writeBytesReference(this.content);
            boolean hasXContentType = this.xContentType != null;
            out.writeBoolean(hasXContentType);
            if (hasXContentType) {
                this.xContentType.writeTo(out);
            }
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.jobId, this.resetStart, this.resetEnd, this.dataDescription, this.xContentType});
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.resetStart, other.resetStart) && Objects.equals(this.resetEnd, other.resetEnd) && Objects.equals((Object)this.dataDescription, (Object)other.dataDescription) && Objects.equals(this.xContentType, other.xContentType);
        }
    }

    public static class Response
    extends BaseTasksResponse
    implements StatusToXContentObject,
    Writeable {
        private DataCounts dataCounts;

        Response(String jobId) {
            this.dataCounts = new DataCounts(jobId);
        }

        private Response() {
        }

        public Response(DataCounts counts) {
            super(null, null);
            this.dataCounts = counts;
        }

        public DataCounts getDataCounts() {
            return this.dataCounts;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.dataCounts = new DataCounts(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.dataCounts.writeTo(out);
        }

        public RestStatus status() {
            return RestStatus.ACCEPTED;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.dataCounts.doXContentBody(builder, params);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hashCode((Object)this.dataCounts);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals((Object)this.dataCounts, (Object)other.dataCounts);
        }
    }

    static class RequestBuilder
    extends ActionRequestBuilder<Request, Response, RequestBuilder> {
        RequestBuilder(ElasticsearchClient client, PostDataAction action) {
            super(client, (Action)action, (ActionRequest)new Request());
        }
    }
}

