/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ml.action.util.QueryPage;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.messages.Messages;
import org.elasticsearch.xpack.ml.job.persistence.JobDataDeleter;
import org.elasticsearch.xpack.ml.job.persistence.JobProvider;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.ml.notifications.Auditor;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;

public class DeleteModelSnapshotAction
extends Action<Request, Response, RequestBuilder> {
    public static final DeleteModelSnapshotAction INSTANCE = new DeleteModelSnapshotAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/model_snapshots/delete";

    private DeleteModelSnapshotAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class TransportAction
    extends HandledTransportAction<Request, Response> {
        private final Client client;
        private final JobProvider jobProvider;
        private final JobManager jobManager;
        private final ClusterService clusterService;
        private final Auditor auditor;

        @Inject
        public TransportAction(Settings settings, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, JobProvider jobProvider, JobManager jobManager, ClusterService clusterService, Client client, Auditor auditor) {
            super(settings, DeleteModelSnapshotAction.NAME, threadPool, transportService, actionFilters, indexNameExpressionResolver, () -> new Request());
            this.client = client;
            this.jobProvider = jobProvider;
            this.jobManager = jobManager;
            this.clusterService = clusterService;
            this.auditor = auditor;
        }

        protected void doExecute(final Request request, final ActionListener<Response> listener) {
            this.jobProvider.modelSnapshots(request.getJobId(), 0, 1, null, null, null, true, request.getSnapshotId(), null, page -> {
                String currentModelInUse;
                List deleteCandidates = page.results();
                if (deleteCandidates.size() > 1) {
                    this.logger.warn("More than one model found for [job_id: " + request.getJobId() + ", snapshot_id: " + request.getSnapshotId() + "] tuple.");
                }
                if (deleteCandidates.isEmpty()) {
                    listener.onFailure((Exception)new ResourceNotFoundException(Messages.getMessage("No model snapshot with id [{0}] exists for job [{1}]", request.getSnapshotId(), request.getJobId()), new Object[0]));
                    return;
                }
                final ModelSnapshot deleteCandidate = (ModelSnapshot)((Object)((Object)deleteCandidates.get(0)));
                QueryPage<Job> job = this.jobManager.getJob(request.getJobId(), this.clusterService.state());
                if (job.count() > 0L && (currentModelInUse = job.results().get(0).getModelSnapshotId()) != null && currentModelInUse.equals(request.getSnapshotId())) {
                    throw new IllegalArgumentException(Messages.getMessage("Model snapshot ''{0}'' is the active snapshot for job ''{1}'', so cannot be deleted", request.getSnapshotId(), request.getJobId()));
                }
                JobDataDeleter deleter = new JobDataDeleter(this.client, request.getJobId());
                deleter.deleteModelSnapshot(deleteCandidate);
                deleter.commit(new ActionListener<BulkResponse>(){

                    public void onResponse(BulkResponse bulkResponse) {
                        auditor.info(request.getJobId(), Messages.getMessage("Job model snapshot ''{0}'' deleted", deleteCandidate.getDescription()));
                        listener.onResponse((Object)new Response(true));
                    }

                    public void onFailure(Exception e) {
                        listener.onFailure(e);
                    }
                }, true);
            }, arg_0 -> listener.onFailure(arg_0));
        }
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, Response, RequestBuilder> {
        public RequestBuilder(ElasticsearchClient client, DeleteModelSnapshotAction action) {
            super(client, (Action)action, (ActionRequest)new Request());
        }
    }

    public static class Response
    extends AcknowledgedResponse {
        public Response(boolean acknowledged) {
            super(acknowledged);
        }

        private Response() {
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.readAcknowledged(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.writeAcknowledged(out);
        }
    }

    public static class Request
    extends ActionRequest {
        private String jobId;
        private String snapshotId;

        private Request() {
        }

        public Request(String jobId, String snapshotId) {
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
            this.snapshotId = ExceptionsHelper.requireNonNull(snapshotId, ModelSnapshot.SNAPSHOT_ID.getPreferredName());
        }

        public String getJobId() {
            return this.jobId;
        }

        public String getSnapshotId() {
            return this.snapshotId;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.jobId = in.readString();
            this.snapshotId = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.jobId);
            out.writeString(this.snapshotId);
        }
    }
}

