/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.ml.datafeed.DatafeedManager;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;

public class InvalidLicenseEnforcer
extends AbstractComponent {
    private final ThreadPool threadPool;
    private final XPackLicenseState licenseState;
    private final DatafeedManager datafeedManager;
    private final AutodetectProcessManager autodetectProcessManager;

    InvalidLicenseEnforcer(Settings settings, XPackLicenseState licenseState, ThreadPool threadPool, DatafeedManager datafeedManager, AutodetectProcessManager autodetectProcessManager) {
        super(settings);
        this.threadPool = threadPool;
        this.licenseState = licenseState;
        this.datafeedManager = datafeedManager;
        this.autodetectProcessManager = autodetectProcessManager;
        licenseState.addListener(this::closeJobsAndDatafeedsIfLicenseExpired);
    }

    private void closeJobsAndDatafeedsIfLicenseExpired() {
        if (!this.licenseState.isMachineLearningAllowed()) {
            this.threadPool.generic().execute((Runnable)new AbstractRunnable(){

                public void onFailure(Exception e) {
                    InvalidLicenseEnforcer.this.logger.warn("cannot close all jobs", (Throwable)e);
                }

                protected void doRun() throws Exception {
                    InvalidLicenseEnforcer.this.datafeedManager.stopAllDatafeeds("invalid license");
                    InvalidLicenseEnforcer.this.autodetectProcessManager.closeAllJobs("invalid license");
                }
            });
        }
    }
}

