/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.common.action;

import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.byscroll.AbstractBulkByScrollRequest;
import org.elasticsearch.action.bulk.byscroll.AbstractBulkByScrollRequestBuilder;
import org.elasticsearch.action.bulk.byscroll.AsyncDeleteByQueryAction;
import org.elasticsearch.action.bulk.byscroll.BulkByScrollParallelizationHelper;
import org.elasticsearch.action.bulk.byscroll.BulkByScrollResponse;
import org.elasticsearch.action.bulk.byscroll.DeleteByQueryRequest;
import org.elasticsearch.action.bulk.byscroll.ParentBulkByScrollTask;
import org.elasticsearch.action.bulk.byscroll.WorkingBulkByScrollTask;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class XPackDeleteByQueryAction
extends Action<DeleteByQueryRequest, BulkByScrollResponse, XPackDeleteByQueryRequestBuilder> {
    public static final XPackDeleteByQueryAction INSTANCE = new XPackDeleteByQueryAction();
    public static final String NAME = "indices:internal/data/write/xpackdeletebyquery";

    private XPackDeleteByQueryAction() {
        super(NAME);
    }

    public XPackDeleteByQueryRequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new XPackDeleteByQueryRequestBuilder(client, this);
    }

    public BulkByScrollResponse newResponse() {
        return new BulkByScrollResponse();
    }

    private static IndicesOptions addIgnoreUnavailable(IndicesOptions indicesOptions) {
        return IndicesOptions.fromOptions((boolean)true, (boolean)indicesOptions.allowNoIndices(), (boolean)indicesOptions.expandWildcardsOpen(), (boolean)indicesOptions.expandWildcardsClosed(), (IndicesOptions)indicesOptions);
    }

    public static class TransportAction
    extends HandledTransportAction<DeleteByQueryRequest, BulkByScrollResponse> {
        private final Client client;
        private final ScriptService scriptService;
        private final ClusterService clusterService;

        @Inject
        public TransportAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver resolver, Client client, TransportService transportService, ScriptService scriptService, ClusterService clusterService) {
            super(settings, XPackDeleteByQueryAction.NAME, threadPool, transportService, actionFilters, resolver, DeleteByQueryRequest::new);
            this.client = client;
            this.scriptService = scriptService;
            this.clusterService = clusterService;
        }

        public void doExecute(Task task, DeleteByQueryRequest request, ActionListener<BulkByScrollResponse> listener) {
            if (request.getSlices() > 1) {
                BulkByScrollParallelizationHelper.startSlices((Client)this.client, (TaskManager)this.taskManager, (Action)INSTANCE, (String)this.clusterService.localNode().getId(), (ParentBulkByScrollTask)((ParentBulkByScrollTask)task), (AbstractBulkByScrollRequest)request, listener);
            } else {
                ClusterState state = this.clusterService.state();
                ParentTaskAssigningClient client = new ParentTaskAssigningClient(this.client, this.clusterService.localNode(), task);
                new AsyncDeleteByQueryAction((WorkingBulkByScrollTask)task, this.logger, client, this.threadPool, request, this.scriptService, state, listener).start();
            }
        }

        protected void doExecute(DeleteByQueryRequest request, ActionListener<BulkByScrollResponse> listener) {
            throw new UnsupportedOperationException("task required");
        }
    }

    public static class XPackDeleteByQueryRequestBuilder
    extends AbstractBulkByScrollRequestBuilder<DeleteByQueryRequest, XPackDeleteByQueryRequestBuilder> {
        private XPackDeleteByQueryRequestBuilder(ElasticsearchClient client, Action<DeleteByQueryRequest, BulkByScrollResponse, XPackDeleteByQueryRequestBuilder> action) {
            this(client, action, new SearchRequestBuilder(client, SearchAction.INSTANCE));
        }

        private XPackDeleteByQueryRequestBuilder(ElasticsearchClient client, Action<DeleteByQueryRequest, BulkByScrollResponse, XPackDeleteByQueryRequestBuilder> action, SearchRequestBuilder search) {
            super(client, action, search, (AbstractBulkByScrollRequest)new DeleteByQueryRequest((SearchRequest)search.setIndicesOptions(XPackDeleteByQueryAction.addIgnoreUnavailable(SearchRequest.DEFAULT_INDICES_OPTIONS)).request()));
        }

        protected XPackDeleteByQueryRequestBuilder self() {
            return this;
        }

        public XPackDeleteByQueryRequestBuilder abortOnVersionConflict(boolean abortOnVersionConflict) {
            ((DeleteByQueryRequest)this.request).setAbortOnVersionConflict(abortOnVersionConflict);
            return this;
        }
    }
}

