/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.trigger.schedule.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.scheduler.SchedulerEngine;
import org.elasticsearch.xpack.support.clock.Clock;
import org.elasticsearch.xpack.watcher.trigger.TriggerEngine;
import org.elasticsearch.xpack.watcher.trigger.schedule.ScheduleRegistry;
import org.elasticsearch.xpack.watcher.trigger.schedule.ScheduleTrigger;
import org.elasticsearch.xpack.watcher.trigger.schedule.ScheduleTriggerEngine;
import org.elasticsearch.xpack.watcher.trigger.schedule.ScheduleTriggerEvent;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class SchedulerScheduleTriggerEngine
extends ScheduleTriggerEngine {
    private final SchedulerEngine schedulerEngine;

    @Inject
    public SchedulerScheduleTriggerEngine(Settings settings, ScheduleRegistry scheduleRegistry, Clock clock) {
        super(settings, scheduleRegistry, clock);
        this.schedulerEngine = new SchedulerEngine(clock);
        this.schedulerEngine.register((SchedulerEngine.Event event) -> this.notifyListeners(event.getJobName(), event.getTriggeredTime(), event.getScheduledTime()));
    }

    @Override
    public void start(Collection<TriggerEngine.Job> jobs) {
        this.logger.debug("starting schedule engine...");
        ArrayList<SchedulerEngine.Job> schedulerJobs = new ArrayList<SchedulerEngine.Job>();
        jobs.stream().filter(job -> job.trigger() instanceof ScheduleTrigger).forEach(job -> {
            ScheduleTrigger trigger = (ScheduleTrigger)job.trigger();
            schedulerJobs.add(new SchedulerEngine.Job(job.id(), trigger.getSchedule()));
        });
        this.schedulerEngine.start(schedulerJobs);
        this.logger.debug("schedule engine started at [{}]", (Object)this.clock.nowUTC());
    }

    @Override
    public void stop() {
        this.logger.debug("stopping schedule engine...");
        this.schedulerEngine.stop();
        this.logger.debug("schedule engine stopped");
    }

    @Override
    public void add(TriggerEngine.Job job) {
        assert (job.trigger() instanceof ScheduleTrigger);
        ScheduleTrigger trigger = (ScheduleTrigger)job.trigger();
        this.schedulerEngine.add(new SchedulerEngine.Job(job.id(), trigger.getSchedule()));
    }

    @Override
    public boolean remove(String jobId) {
        return this.schedulerEngine.remove(jobId);
    }

    protected void notifyListeners(String name, long triggeredTime, long scheduledTime) {
        this.logger.trace("triggered job [{}] at [{}] (scheduled time was [{}])", (Object)name, (Object)new DateTime(triggeredTime, DateTimeZone.UTC), (Object)new DateTime(scheduledTime, DateTimeZone.UTC));
        ScheduleTriggerEvent event = new ScheduleTriggerEvent(name, new DateTime(triggeredTime, DateTimeZone.UTC), new DateTime(scheduledTime, DateTimeZone.UTC));
        for (TriggerEngine.Listener listener : this.listeners) {
            listener.triggered(Collections.singletonList(event));
        }
    }
}

