/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.support.search;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchRequestParsers;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.watcher.Watcher;
import org.elasticsearch.xpack.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.watcher.support.Variables;
import org.elasticsearch.xpack.watcher.support.search.WatcherSearchTemplateRequest;
import org.elasticsearch.xpack.watcher.watch.Payload;

public class WatcherSearchTemplateService
extends AbstractComponent {
    private final ScriptService scriptService;
    private final ParseFieldMatcher parseFieldMatcher;
    private final SearchRequestParsers searchRequestParsers;
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public WatcherSearchTemplateService(Settings settings, ScriptService scriptService, SearchRequestParsers searchRequestParsers, NamedXContentRegistry xContentRegistry) {
        super(settings);
        this.scriptService = scriptService;
        this.searchRequestParsers = searchRequestParsers;
        this.parseFieldMatcher = new ParseFieldMatcher(settings);
        this.xContentRegistry = xContentRegistry;
    }

    public BytesReference renderTemplate(Script source, WatchExecutionContext ctx, Payload payload) throws IOException {
        Map<String, Object> watcherContextParams = Variables.createCtxModel(ctx, payload);
        if (source.getParams() != null) {
            watcherContextParams.putAll(source.getParams());
        }
        Script template = new Script(source.getType(), "mustache", source.getIdOrCode(), source.getOptions(), watcherContextParams);
        CompiledScript compiledScript = this.scriptService.compile(template, Watcher.SCRIPT_CONTEXT, Collections.emptyMap());
        return (BytesReference)this.scriptService.executable(compiledScript, template.getParams()).run();
    }

    public SearchRequest toSearchRequest(WatcherSearchTemplateRequest request) throws IOException {
        SearchRequest searchRequest = new SearchRequest(request.getIndices());
        searchRequest.types(request.getTypes());
        searchRequest.searchType(request.getSearchType());
        searchRequest.indicesOptions(request.getIndicesOptions());
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        BytesReference source = request.getSearchSource();
        if (source != null && source.length() > 0) {
            try (XContentParser parser = XContentFactory.xContent((BytesReference)source).createParser(this.xContentRegistry, source);){
                sourceBuilder.parseXContent(new QueryParseContext(parser, this.parseFieldMatcher), this.searchRequestParsers.aggParsers, this.searchRequestParsers.suggesters, this.searchRequestParsers.searchExtParsers);
                searchRequest.source(sourceBuilder);
            }
        }
        return searchRequest;
    }
}

