/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.support;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xpack.watcher.support.WatcherDateTimeUtils;
import org.joda.time.DateTime;

public final class WatcherUtils {
    private WatcherUtils() {
    }

    public static Map<String, Object> responseToData(ToXContent response) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().value((Object)response).endObject();
        return (Map)XContentHelper.convertToMap((BytesReference)builder.bytes(), (boolean)false).v2();
    }

    public static Map<String, Object> flattenModel(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        WatcherUtils.flattenModel("", map, result);
        return result;
    }

    private static void flattenModel(String key, Object value, Map<String, Object> result) {
        if (value == null) {
            result.put(key, null);
            return;
        }
        if (value instanceof Map) {
            for (Map.Entry entry : ((Map)value).entrySet()) {
                if ("".equals(key)) {
                    WatcherUtils.flattenModel((String)entry.getKey(), entry.getValue(), result);
                    continue;
                }
                WatcherUtils.flattenModel(key + "." + (String)entry.getKey(), entry.getValue(), result);
            }
            return;
        }
        if (value instanceof Iterable) {
            int i = 0;
            for (Object item : (Iterable)value) {
                WatcherUtils.flattenModel(key + "." + i++, item, result);
            }
            return;
        }
        if (value.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(value); ++i) {
                WatcherUtils.flattenModel(key + "." + i, Array.get(value, i), result);
            }
            return;
        }
        if (value instanceof DateTime) {
            result.put(key, WatcherDateTimeUtils.formatDate((DateTime)value));
            return;
        }
        if (value instanceof TimeValue) {
            result.put(key, String.valueOf(((TimeValue)value).getMillis()));
            return;
        }
        result.put(key, String.valueOf(value));
    }
}

