/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.rest.action;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.AcknowledgedRestListener;
import org.elasticsearch.xpack.watcher.client.WatcherClient;
import org.elasticsearch.xpack.watcher.rest.WatcherRestHandler;
import org.elasticsearch.xpack.watcher.transport.actions.service.WatcherServiceRequest;
import org.elasticsearch.xpack.watcher.transport.actions.service.WatcherServiceResponse;

public class RestWatchServiceAction
extends WatcherRestHandler {
    @Inject
    public RestWatchServiceAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, URI_BASE + "/_restart", (RestHandler)this, RestRequest.Method.PUT, "/_watcher/_restart", this.deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, URI_BASE + "/_start", (RestHandler)new StartRestHandler(settings), RestRequest.Method.PUT, "/_watcher/_start", this.deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, URI_BASE + "/_stop", (RestHandler)new StopRestHandler(settings), RestRequest.Method.PUT, "/_watcher/_stop", this.deprecationLogger);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, WatcherClient client) throws IOException {
        return channel -> client.watcherService(new WatcherServiceRequest().restart(), (ActionListener<WatcherServiceResponse>)new AcknowledgedRestListener(channel));
    }

    private static class StopRestHandler
    extends WatcherRestHandler {
        StopRestHandler(Settings settings) {
            super(settings);
        }

        @Override
        public BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, WatcherClient client) throws IOException {
            return channel -> client.watcherService(new WatcherServiceRequest().stop(), (ActionListener<WatcherServiceResponse>)new AcknowledgedRestListener(channel));
        }
    }

    private static class StartRestHandler
    extends WatcherRestHandler {
        StartRestHandler(Settings settings) {
            super(settings);
        }

        @Override
        public BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, WatcherClient client) throws IOException {
            return channel -> client.watcherService(new WatcherServiceRequest().start(), (ActionListener<WatcherServiceResponse>)new AcknowledgedRestListener(channel));
        }
    }
}

