/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.rest.action;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.watcher.client.WatcherClient;
import org.elasticsearch.xpack.watcher.rest.WatcherRestHandler;
import org.elasticsearch.xpack.watcher.transport.actions.delete.DeleteWatchRequest;
import org.elasticsearch.xpack.watcher.transport.actions.delete.DeleteWatchResponse;

public class RestDeleteWatchAction
extends WatcherRestHandler {
    @Inject
    public RestDeleteWatchAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerWithDeprecatedHandler(RestRequest.Method.DELETE, URI_BASE + "/watch/{id}", (RestHandler)this, RestRequest.Method.DELETE, "/_watcher/watch/{id}", this.deprecationLogger);
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, WatcherClient client) throws IOException {
        DeleteWatchRequest deleteWatchRequest = new DeleteWatchRequest(request.param("id"));
        deleteWatchRequest.masterNodeTimeout(request.paramAsTime("master_timeout", deleteWatchRequest.masterNodeTimeout()));
        return channel -> client.deleteWatch(deleteWatchRequest, (ActionListener<DeleteWatchResponse>)new RestBuilderListener<DeleteWatchResponse>(channel){

            public RestResponse buildResponse(DeleteWatchResponse response, XContentBuilder builder) throws Exception {
                builder.startObject().field("_id", response.getId()).field("_version", response.getVersion()).field("found", response.isFound()).endObject();
                RestStatus status = response.isFound() ? RestStatus.OK : RestStatus.NOT_FOUND;
                return new BytesRestResponse(status, builder);
            }
        });
    }
}

