/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.rest.action;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.watcher.client.WatcherClient;
import org.elasticsearch.xpack.watcher.rest.WatcherRestHandler;
import org.elasticsearch.xpack.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.watcher.transport.actions.activate.ActivateWatchRequest;
import org.elasticsearch.xpack.watcher.transport.actions.activate.ActivateWatchResponse;
import org.elasticsearch.xpack.watcher.watch.Watch;

public class RestActivateWatchAction
extends WatcherRestHandler {
    @Inject
    public RestActivateWatchAction(Settings settings, RestController controller) {
        super(settings);
        DeactivateRestHandler deactivateRestHandler = new DeactivateRestHandler(settings);
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, URI_BASE + "/watch/{id}/_activate", (RestHandler)this, RestRequest.Method.POST, "/_watcher/watch/{id}/_activate", this.deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.PUT, URI_BASE + "/watch/{id}/_activate", (RestHandler)this, RestRequest.Method.PUT, "/_watcher/watch/{id}/_activate", this.deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, URI_BASE + "/watch/{id}/_deactivate", (RestHandler)deactivateRestHandler, RestRequest.Method.POST, "/_watcher/watch/{id}/_deactivate", this.deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.PUT, URI_BASE + "/watch/{id}/_deactivate", (RestHandler)deactivateRestHandler, RestRequest.Method.PUT, "/_watcher/watch/{id}/_deactivate", this.deprecationLogger);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, WatcherClient client) throws IOException {
        String watchId = request.param("id");
        return channel -> client.activateWatch(new ActivateWatchRequest(watchId, true), (ActionListener<ActivateWatchResponse>)new RestBuilderListener<ActivateWatchResponse>(channel){

            public RestResponse buildResponse(ActivateWatchResponse response, XContentBuilder builder) throws Exception {
                return new BytesRestResponse(RestStatus.OK, builder.startObject().field(Watch.Field.STATUS.getPreferredName(), (ToXContent)response.getStatus(), (ToXContent.Params)WatcherParams.HIDE_SECRETS).endObject());
            }
        });
    }

    private static class DeactivateRestHandler
    extends WatcherRestHandler {
        DeactivateRestHandler(Settings settings) {
            super(settings);
        }

        @Override
        public BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, WatcherClient client) throws IOException {
            String watchId = request.param("id");
            return channel -> client.activateWatch(new ActivateWatchRequest(watchId, false), (ActionListener<ActivateWatchResponse>)new RestBuilderListener<ActivateWatchResponse>(channel){

                public RestResponse buildResponse(ActivateWatchResponse response, XContentBuilder builder) throws Exception {
                    return new BytesRestResponse(RestStatus.OK, builder.startObject().field(Watch.Field.STATUS.getPreferredName(), (ToXContent)response.getStatus(), (ToXContent.Params)WatcherParams.HIDE_SECRETS).endObject());
                }
            });
        }
    }
}

