/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.input.search;

import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.watcher.input.ExecutableInput;
import org.elasticsearch.xpack.watcher.input.search.SearchInput;
import org.elasticsearch.xpack.watcher.support.XContentFilterKeysUtils;
import org.elasticsearch.xpack.watcher.support.init.proxy.WatcherClientProxy;
import org.elasticsearch.xpack.watcher.support.search.WatcherSearchTemplateRequest;
import org.elasticsearch.xpack.watcher.support.search.WatcherSearchTemplateService;
import org.elasticsearch.xpack.watcher.watch.Payload;

public class ExecutableSearchInput
extends ExecutableInput<SearchInput, SearchInput.Result> {
    public static final SearchType DEFAULT_SEARCH_TYPE = SearchType.QUERY_THEN_FETCH;
    private final WatcherClientProxy client;
    private final WatcherSearchTemplateService searchTemplateService;
    @Nullable
    private final TimeValue timeout;

    public ExecutableSearchInput(SearchInput input, Logger logger, WatcherClientProxy client, WatcherSearchTemplateService searchTemplateService, @Nullable TimeValue defaultTimeout) {
        super(input, logger);
        this.client = client;
        this.searchTemplateService = searchTemplateService;
        this.timeout = input.getTimeout() != null ? input.getTimeout() : defaultTimeout;
    }

    @Override
    public SearchInput.Result execute(WatchExecutionContext ctx, Payload payload) {
        WatcherSearchTemplateRequest request = null;
        try {
            Script template = ((SearchInput)this.input).getRequest().getOrCreateTemplate();
            BytesReference renderedTemplate = this.searchTemplateService.renderTemplate(template, ctx, payload);
            request = new WatcherSearchTemplateRequest(((SearchInput)this.input).getRequest(), renderedTemplate);
            return this.doExecute(ctx, request);
        }
        catch (Exception e) {
            this.logger.error("failed to execute [{}] input for watch [{}], reason [{}]", (Object)"search", (Object)ctx.watch().id(), (Object)e.getMessage());
            return new SearchInput.Result(request, e);
        }
    }

    SearchInput.Result doExecute(WatchExecutionContext ctx, WatcherSearchTemplateRequest request) throws Exception {
        Payload.Simple payload;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[{}] running query for [{}] [{}]", (Object)ctx.id(), (Object)ctx.watch().id(), (Object)request.getSearchSource().utf8ToString());
        }
        SearchResponse response = this.client.search(this.searchTemplateService.toSearchRequest(request), this.timeout);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[{}] found [{}] hits", (Object)ctx.id(), (Object)response.getHits().getTotalHits());
            for (SearchHit hit : response.getHits()) {
                this.logger.debug("[{}] hit [{}]", (Object)ctx.id(), (Object)XContentHelper.toString((ToXContent)hit));
            }
        }
        if (((SearchInput)this.input).getExtractKeys() != null) {
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject().value((Object)response).endObject();
            try (XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (BytesReference)builder.bytes());){
                Map<String, Object> filteredKeys = XContentFilterKeysUtils.filterMapOrdered(((SearchInput)this.input).getExtractKeys(), parser);
                payload = new Payload.Simple(filteredKeys);
            }
        } else {
            payload = new Payload.XContent((ToXContent)response);
        }
        return new SearchInput.Result(request, (Payload)payload);
    }
}

